/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.WebAddress;
import android.net.http.Connection;
import android.net.http.ConnectionThread;
import android.net.http.EventHandler;
import android.net.http.HttpLog;
import android.net.http.IdleCache;
import android.net.http.LoggingEventHandler;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestHandle;
import android.util.Log;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.http.HttpHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestQueue
implements RequestFeeder {
    private final LinkedHashMap<HttpHost, LinkedList<Request>> mPending;
    private final Context mContext;
    private final ActivePool mActivePool;
    private final ConnectivityManager mConnectivityManager;
    private HttpHost mProxyHost = null;
    private BroadcastReceiver mProxyChangeReceiver;
    private static final int CONNECTION_COUNT = 4;

    public RequestQueue(Context context) {
        this(context, 4);
    }

    public RequestQueue(Context context, int connectionCount) {
        this.mContext = context;
        this.mPending = new LinkedHashMap(32);
        this.mActivePool = new ActivePool(connectionCount);
        this.mActivePool.startup();
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    public synchronized void enablePlatformNotifications() {
        if (this.mProxyChangeReceiver == null) {
            this.mProxyChangeReceiver = new BroadcastReceiver(){

                public void onReceive(Context ctx, Intent intent) {
                    RequestQueue.this.setProxyConfig();
                }
            };
            this.mContext.registerReceiver(this.mProxyChangeReceiver, new IntentFilter("android.intent.action.PROXY_CHANGE"));
        }
        this.setProxyConfig();
    }

    public synchronized void disablePlatformNotifications() {
        if (this.mProxyChangeReceiver != null) {
            this.mContext.unregisterReceiver(this.mProxyChangeReceiver);
            this.mProxyChangeReceiver = null;
        }
    }

    private synchronized void setProxyConfig() {
        NetworkInfo info = this.mConnectivityManager.getActiveNetworkInfo();
        if (info != null && info.getType() == 1) {
            this.mProxyHost = null;
        } else {
            String host = Proxy.getHost(this.mContext);
            if (host == null) {
                this.mProxyHost = null;
            } else {
                this.mActivePool.disablePersistence();
                this.mProxyHost = new HttpHost(host, Proxy.getPort(this.mContext), "http");
            }
        }
    }

    public HttpHost getProxyHost() {
        return this.mProxyHost;
    }

    public RequestHandle queueRequest(String url, String method, Map<String, String> headers, EventHandler eventHandler, InputStream bodyProvider, int bodyLength) {
        WebAddress uri = new WebAddress(url);
        return this.queueRequest(url, uri, method, headers, eventHandler, bodyProvider, bodyLength);
    }

    public RequestHandle queueRequest(String url, WebAddress uri, String method, Map<String, String> headers, EventHandler eventHandler, InputStream bodyProvider, int bodyLength) {
        if (eventHandler == null) {
            eventHandler = new LoggingEventHandler();
        }
        HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        Request req = new Request(method, httpHost, this.mProxyHost, uri.getPath(), bodyProvider, bodyLength, eventHandler, headers);
        this.queueRequest(req, false);
        this.mActivePool.mTotalRequest++;
        this.mActivePool.startConnectionThread();
        return new RequestHandle(this, url, uri, method, headers, bodyProvider, bodyLength, req);
    }

    public RequestHandle queueSynchronousRequest(String url, WebAddress uri, String method, Map<String, String> headers, EventHandler eventHandler, InputStream bodyProvider, int bodyLength) {
        HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        Request req = new Request(method, host, this.mProxyHost, uri.getPath(), bodyProvider, bodyLength, eventHandler, headers);
        host = this.determineHost(host);
        Connection conn = Connection.getConnection(this.mContext, host, this.mProxyHost, new SyncFeeder());
        return new RequestHandle(this, url, uri, method, headers, bodyProvider, bodyLength, req, conn);
    }

    private HttpHost determineHost(HttpHost host) {
        return this.mProxyHost == null || "https".equals(host.getSchemeName()) ? host : this.mProxyHost;
    }

    synchronized boolean requestsPending() {
        return !this.mPending.isEmpty();
    }

    synchronized void dump() {
        HttpLog.v("dump()");
        StringBuilder dump = new StringBuilder();
        int count = 0;
        if (!this.mPending.isEmpty()) {
            Iterator<Map.Entry<HttpHost, LinkedList<Request>>> iter = this.mPending.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<HttpHost, LinkedList<Request>> entry = iter.next();
                String hostName = entry.getKey().getHostName();
                StringBuilder line = new StringBuilder("p" + count++ + " " + hostName + " ");
                LinkedList<Request> reqList = entry.getValue();
                ListIterator<Request> reqIter = reqList.listIterator(0);
                while (iter.hasNext()) {
                    Request request = (Request)((Object)iter.next());
                    line.append(request + " ");
                }
                dump.append((CharSequence)line);
                dump.append("\n");
            }
        }
        HttpLog.v(dump.toString());
    }

    @Override
    public synchronized Request getRequest() {
        Request ret = null;
        if (!this.mPending.isEmpty()) {
            ret = this.removeFirst(this.mPending);
        }
        return ret;
    }

    @Override
    public synchronized Request getRequest(HttpHost host) {
        Request ret = null;
        if (this.mPending.containsKey(host)) {
            LinkedList<Request> reqList = this.mPending.get(host);
            ret = reqList.removeFirst();
            if (reqList.isEmpty()) {
                this.mPending.remove(host);
            }
        }
        return ret;
    }

    @Override
    public synchronized boolean haveRequest(HttpHost host) {
        return this.mPending.containsKey(host);
    }

    @Override
    public void requeueRequest(Request request) {
        this.queueRequest(request, true);
    }

    public void shutdown() {
        this.mActivePool.shutdown();
    }

    protected synchronized void queueRequest(Request request, boolean head) {
        LinkedList<Object> reqList;
        HttpHost host;
        HttpHost httpHost = host = request.mProxyHost == null ? request.mHost : request.mProxyHost;
        if (this.mPending.containsKey(host)) {
            reqList = this.mPending.get(host);
        } else {
            reqList = new LinkedList();
            this.mPending.put(host, reqList);
        }
        if (head) {
            reqList.addFirst(request);
        } else {
            reqList.add(request);
        }
    }

    public void startTiming() {
        this.mActivePool.startTiming();
    }

    public void stopTiming() {
        this.mActivePool.stopTiming();
    }

    private Request removeFirst(LinkedHashMap<HttpHost, LinkedList<Request>> requestQueue) {
        Request ret = null;
        Iterator<Map.Entry<HttpHost, LinkedList<Request>>> iter = requestQueue.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<HttpHost, LinkedList<Request>> entry = iter.next();
            LinkedList<Request> reqList = entry.getValue();
            ret = reqList.removeFirst();
            if (reqList.isEmpty()) {
                requestQueue.remove(entry.getKey());
            }
        }
        return ret;
    }

    static interface ConnectionManager {
        public HttpHost getProxyHost();

        public Connection getConnection(Context var1, HttpHost var2);

        public boolean recycleConnection(Connection var1);
    }

    private static class SyncFeeder
    implements RequestFeeder {
        private Request mRequest;

        SyncFeeder() {
        }

        public Request getRequest() {
            Request r = this.mRequest;
            this.mRequest = null;
            return r;
        }

        public Request getRequest(HttpHost host) {
            return this.getRequest();
        }

        public boolean haveRequest(HttpHost host) {
            return this.mRequest != null;
        }

        public void requeueRequest(Request r) {
            this.mRequest = r;
        }
    }

    class ActivePool
    implements ConnectionManager {
        ConnectionThread[] mThreads;
        IdleCache mIdleCache = new IdleCache();
        private int mTotalRequest;
        private int mTotalConnection;
        private int mConnectionCount;

        ActivePool(int connectionCount) {
            this.mConnectionCount = connectionCount;
            this.mThreads = new ConnectionThread[this.mConnectionCount];
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i] = new ConnectionThread(RequestQueue.this.mContext, i, this, RequestQueue.this);
            }
        }

        void startup() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i].start();
            }
        }

        void shutdown() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i].requestStop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startConnectionThread() {
            RequestQueue requestQueue = RequestQueue.this;
            synchronized (requestQueue) {
                RequestQueue.this.notify();
            }
        }

        public void startTiming() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                ConnectionThread rt = this.mThreads[i];
                rt.mCurrentThreadTime = -1L;
                rt.mTotalThreadTime = 0L;
            }
            this.mTotalRequest = 0;
            this.mTotalConnection = 0;
        }

        public void stopTiming() {
            int totalTime = 0;
            for (int i = 0; i < this.mConnectionCount; ++i) {
                ConnectionThread rt = this.mThreads[i];
                if (rt.mCurrentThreadTime != -1L) {
                    totalTime = (int)((long)totalTime + rt.mTotalThreadTime);
                }
                rt.mCurrentThreadTime = 0L;
            }
            Log.d("Http", "Http thread used " + totalTime + " ms " + " for " + this.mTotalRequest + " requests and " + this.mTotalConnection + " new connections");
        }

        void logState() {
            StringBuilder dump = new StringBuilder();
            for (int i = 0; i < this.mConnectionCount; ++i) {
                dump.append(this.mThreads[i] + "\n");
            }
            HttpLog.v(dump.toString());
        }

        public HttpHost getProxyHost() {
            return RequestQueue.this.mProxyHost;
        }

        void disablePersistence() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                Connection connection = this.mThreads[i].mConnection;
                if (connection == null) continue;
                connection.setCanPersist(false);
            }
            this.mIdleCache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConnectionThread getThread(HttpHost host) {
            RequestQueue requestQueue = RequestQueue.this;
            synchronized (requestQueue) {
                for (int i = 0; i < this.mThreads.length; ++i) {
                    ConnectionThread ct = this.mThreads[i];
                    Connection connection = ct.mConnection;
                    if (connection == null || !connection.mHost.equals((Object)host)) continue;
                    return ct;
                }
            }
            return null;
        }

        public Connection getConnection(Context context, HttpHost host) {
            Connection con = this.mIdleCache.getConnection(host = RequestQueue.this.determineHost(host));
            if (con == null) {
                ++this.mTotalConnection;
                con = Connection.getConnection(RequestQueue.this.mContext, host, RequestQueue.this.mProxyHost, RequestQueue.this);
            }
            return con;
        }

        public boolean recycleConnection(Connection connection) {
            return this.mIdleCache.cacheConnection(connection.getHost(), connection);
        }
    }
}

