/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import android.net.rtp.AudioCodec;
import android.net.rtp.AudioGroup;
import android.net.rtp.RtpStream;
import java.net.InetAddress;
import java.net.SocketException;

public class AudioStream
extends RtpStream {
    private AudioCodec mCodec;
    private int mDtmfType = -1;
    private AudioGroup mGroup;

    public AudioStream(InetAddress address) throws SocketException {
        super(address);
    }

    public boolean isBusy() {
        return this.mGroup != null;
    }

    public AudioGroup getGroup() {
        return this.mGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(AudioGroup group) {
        AudioStream audioStream = this;
        synchronized (audioStream) {
            if (this.mGroup == group) {
                return;
            }
            if (this.mGroup != null) {
                this.mGroup.remove(this);
                this.mGroup = null;
            }
            if (group != null) {
                group.add(this, this.mCodec, this.mDtmfType);
                this.mGroup = group;
            }
        }
    }

    public AudioCodec getCodec() {
        return this.mCodec;
    }

    public void setCodec(AudioCodec codec) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        if (codec.type == this.mDtmfType) {
            throw new IllegalArgumentException("The type is used by DTMF");
        }
        this.mCodec = codec;
    }

    public int getDtmfType() {
        return this.mDtmfType;
    }

    public void setDtmfType(int type) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        if (type != -1) {
            if (type < 96 || type > 127) {
                throw new IllegalArgumentException("Invalid type");
            }
            if (type == this.mCodec.type) {
                throw new IllegalArgumentException("The type is used by codec");
            }
        }
        this.mDtmfType = type;
    }
}

