/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;

public class SipProfile
implements Parcelable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PORT = 5060;
    private static final String TCP = "TCP";
    private static final String UDP = "UDP";
    private Address mAddress;
    private String mProxyAddress;
    private String mPassword;
    private String mDomain;
    private String mProtocol = "UDP";
    private String mProfileName;
    private String mAuthUserName;
    private int mPort = 5060;
    private boolean mSendKeepAlive = false;
    private boolean mAutoRegistration = true;
    private transient int mCallingUid = 0;
    public static final Parcelable.Creator<SipProfile> CREATOR = new Parcelable.Creator<SipProfile>(){

        @Override
        public SipProfile createFromParcel(Parcel in) {
            return new SipProfile(in);
        }

        public SipProfile[] newArray(int size) {
            return new SipProfile[size];
        }
    };

    private SipProfile() {
    }

    private SipProfile(Parcel in) {
        this.mAddress = (Address)in.readSerializable();
        this.mProxyAddress = in.readString();
        this.mPassword = in.readString();
        this.mDomain = in.readString();
        this.mProtocol = in.readString();
        this.mProfileName = in.readString();
        this.mSendKeepAlive = in.readInt() != 0;
        this.mAutoRegistration = in.readInt() != 0;
        this.mCallingUid = in.readInt();
        this.mPort = in.readInt();
        this.mAuthUserName = in.readString();
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeSerializable((Serializable)this.mAddress);
        out.writeString(this.mProxyAddress);
        out.writeString(this.mPassword);
        out.writeString(this.mDomain);
        out.writeString(this.mProtocol);
        out.writeString(this.mProfileName);
        out.writeInt(this.mSendKeepAlive ? 1 : 0);
        out.writeInt(this.mAutoRegistration ? 1 : 0);
        out.writeInt(this.mCallingUid);
        out.writeInt(this.mPort);
        out.writeString(this.mAuthUserName);
    }

    public int describeContents() {
        return 0;
    }

    public SipURI getUri() {
        return (SipURI)this.mAddress.getURI();
    }

    public String getUriString() {
        if (!TextUtils.isEmpty(this.mProxyAddress)) {
            return "sip:" + this.getUserName() + "@" + this.mDomain;
        }
        return this.getUri().toString();
    }

    public Address getSipAddress() {
        return this.mAddress;
    }

    public String getDisplayName() {
        return this.mAddress.getDisplayName();
    }

    public String getUserName() {
        return this.getUri().getUser();
    }

    public String getAuthUserName() {
        return this.mAuthUserName;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public String getSipDomain() {
        return this.mDomain;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getProtocol() {
        return this.mProtocol;
    }

    public String getProxyAddress() {
        return this.mProxyAddress;
    }

    public String getProfileName() {
        return this.mProfileName;
    }

    public boolean getSendKeepAlive() {
        return this.mSendKeepAlive;
    }

    public boolean getAutoRegistration() {
        return this.mAutoRegistration;
    }

    public void setCallingUid(int uid) {
        this.mCallingUid = uid;
    }

    public int getCallingUid() {
        return this.mCallingUid;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.mPort == 0) {
            this.mPort = 5060;
        }
        return this;
    }

    public static class Builder {
        private AddressFactory mAddressFactory;
        private SipProfile mProfile = new SipProfile();
        private SipURI mUri;
        private String mDisplayName;
        private String mProxyAddress;

        public Builder(SipProfile profile) {
            try {
                this.mAddressFactory = SipFactory.getInstance().createAddressFactory();
            }
            catch (PeerUnavailableException e) {
                throw new RuntimeException(e);
            }
            if (profile == null) {
                throw new NullPointerException();
            }
            try {
                this.mProfile = (SipProfile)profile.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("should not occur", e);
            }
            this.mProfile.mAddress = null;
            this.mUri = profile.getUri();
            this.mUri.setUserPassword(profile.getPassword());
            this.mDisplayName = profile.getDisplayName();
            this.mProxyAddress = profile.getProxyAddress();
            this.mProfile.mPort = profile.getPort();
        }

        public Builder(String uriString) throws ParseException {
            try {
                this.mAddressFactory = SipFactory.getInstance().createAddressFactory();
            }
            catch (PeerUnavailableException e) {
                throw new RuntimeException(e);
            }
            if (uriString == null) {
                throw new NullPointerException("uriString cannot be null");
            }
            URI uri = this.mAddressFactory.createURI(this.fix(uriString));
            if (!(uri instanceof SipURI)) {
                throw new ParseException(uriString + " is not a SIP URI", 0);
            }
            this.mUri = (SipURI)uri;
            this.mProfile.mDomain = this.mUri.getHost();
        }

        public Builder(String username, String serverDomain) throws ParseException {
            try {
                this.mAddressFactory = SipFactory.getInstance().createAddressFactory();
            }
            catch (PeerUnavailableException e) {
                throw new RuntimeException(e);
            }
            if (username == null || serverDomain == null) {
                throw new NullPointerException("username and serverDomain cannot be null");
            }
            this.mUri = this.mAddressFactory.createSipURI(username, serverDomain);
            this.mProfile.mDomain = serverDomain;
        }

        private String fix(String uriString) {
            return uriString.trim().toLowerCase().startsWith("sip:") ? uriString : "sip:" + uriString;
        }

        public Builder setAuthUserName(String name) {
            this.mProfile.mAuthUserName = name;
            return this;
        }

        public Builder setProfileName(String name) {
            this.mProfile.mProfileName = name;
            return this;
        }

        public Builder setPassword(String password) {
            this.mUri.setUserPassword(password);
            return this;
        }

        public Builder setPort(int port) throws IllegalArgumentException {
            if (port > 65535 || port < 1000) {
                throw new IllegalArgumentException("incorrect port arugment: " + port);
            }
            this.mProfile.mPort = port;
            return this;
        }

        public Builder setProtocol(String protocol) throws IllegalArgumentException {
            if (protocol == null) {
                throw new NullPointerException("protocol cannot be null");
            }
            if (!(protocol = protocol.toUpperCase()).equals(SipProfile.UDP) && !protocol.equals(SipProfile.TCP)) {
                throw new IllegalArgumentException("unsupported protocol: " + protocol);
            }
            this.mProfile.mProtocol = protocol;
            return this;
        }

        public Builder setOutboundProxy(String outboundProxy) {
            this.mProxyAddress = outboundProxy;
            return this;
        }

        public Builder setDisplayName(String displayName) {
            this.mDisplayName = displayName;
            return this;
        }

        public Builder setSendKeepAlive(boolean flag) {
            this.mProfile.mSendKeepAlive = flag;
            return this;
        }

        public Builder setAutoRegistration(boolean flag) {
            this.mProfile.mAutoRegistration = flag;
            return this;
        }

        public SipProfile build() {
            this.mProfile.mPassword = this.mUri.getUserPassword();
            this.mUri.setUserPassword(null);
            try {
                if (!TextUtils.isEmpty(this.mProxyAddress)) {
                    SipURI uri = (SipURI)this.mAddressFactory.createURI(this.fix(this.mProxyAddress));
                    this.mProfile.mProxyAddress = uri.getHost();
                } else {
                    if (!this.mProfile.mProtocol.equals(SipProfile.UDP)) {
                        this.mUri.setTransportParam(this.mProfile.mProtocol);
                    }
                    if (this.mProfile.mPort != 5060) {
                        this.mUri.setPort(this.mProfile.mPort);
                    }
                }
                this.mProfile.mAddress = this.mAddressFactory.createAddress(this.mDisplayName, (URI)this.mUri);
            }
            catch (InvalidArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return this.mProfile;
        }
    }
}

