/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.provider.BaseColumns;
import android.provider.BrowserContract;
import android.util.Log;
import android.webkit.WebIconDatabase;

public class Browser {
    private static final String LOGTAG = "browser";
    public static final Uri BOOKMARKS_URI = Uri.parse("content://browser/bookmarks");
    public static final String INITIAL_ZOOM_LEVEL = "browser.initialZoomLevel";
    public static final String EXTRA_APPLICATION_ID = "com.android.browser.application_id";
    public static final String EXTRA_HEADERS = "com.android.browser.headers";
    public static final String[] HISTORY_PROJECTION = new String[]{"_id", "url", "visits", "date", "bookmark", "title", "favicon", "thumbnail", "touch_icon", "user_entered"};
    public static final int HISTORY_PROJECTION_ID_INDEX = 0;
    public static final int HISTORY_PROJECTION_URL_INDEX = 1;
    public static final int HISTORY_PROJECTION_VISITS_INDEX = 2;
    public static final int HISTORY_PROJECTION_DATE_INDEX = 3;
    public static final int HISTORY_PROJECTION_BOOKMARK_INDEX = 4;
    public static final int HISTORY_PROJECTION_TITLE_INDEX = 5;
    public static final int HISTORY_PROJECTION_FAVICON_INDEX = 6;
    public static final int HISTORY_PROJECTION_THUMBNAIL_INDEX = 7;
    public static final int HISTORY_PROJECTION_TOUCH_ICON_INDEX = 8;
    public static final String[] TRUNCATE_HISTORY_PROJECTION = new String[]{"_id", "date"};
    public static final int TRUNCATE_HISTORY_PROJECTION_ID_INDEX = 0;
    public static final int TRUNCATE_N_OLDEST = 5;
    public static final Uri SEARCHES_URI = Uri.parse("content://browser/searches");
    public static final String[] SEARCHES_PROJECTION = new String[]{"_id", "search", "date"};
    public static final int SEARCHES_PROJECTION_SEARCH_INDEX = 1;
    public static final int SEARCHES_PROJECTION_DATE_INDEX = 2;
    private static final int MAX_HISTORY_COUNT = 250;
    public static final String EXTRA_CREATE_NEW_TAB = "create_new_tab";
    public static final String EXTRA_SHARE_SCREENSHOT = "share_screenshot";
    public static final String EXTRA_SHARE_FAVICON = "share_favicon";

    public static void saveBookmark(Context c, String title, String url) {
        Intent i = new Intent("android.intent.action.INSERT", BOOKMARKS_URI);
        i.putExtra("title", title);
        i.putExtra("url", url);
        c.startActivity(i);
    }

    public static void sendString(Context context, String string2) {
        Browser.sendString(context, string2, context.getString(17040309));
    }

    public static void sendString(Context c, String stringToSend, String chooserDialogTitle) {
        Intent send = new Intent("android.intent.action.SEND");
        send.setType("text/plain");
        send.putExtra("android.intent.extra.TEXT", stringToSend);
        try {
            Intent i = Intent.createChooser(send, chooserDialogTitle);
            i.setFlags(0x10000000);
            c.startActivity(i);
        }
        catch (ActivityNotFoundException ex) {
            // empty catch block
        }
    }

    public static Cursor getAllBookmarks(ContentResolver cr) throws IllegalStateException {
        return cr.query(BrowserContract.Bookmarks.CONTENT_URI, new String[]{"url"}, "folder = 0", null, null);
    }

    public static Cursor getAllVisitedUrls(ContentResolver cr) throws IllegalStateException {
        return cr.query(BrowserContract.Combined.CONTENT_URI, new String[]{"url"}, null, null, "created ASC");
    }

    private static void addOrUrlEquals(StringBuilder sb) {
        sb.append(" OR url = ");
    }

    private static Cursor getVisitedLike(ContentResolver cr, String url) {
        boolean secure = false;
        String compareString = url;
        if (compareString.startsWith("http://")) {
            compareString = compareString.substring(7);
        } else if (compareString.startsWith("https://")) {
            compareString = compareString.substring(8);
            secure = true;
        }
        if (compareString.startsWith("www.")) {
            compareString = compareString.substring(4);
        }
        StringBuilder whereClause = null;
        if (secure) {
            whereClause = new StringBuilder("url = ");
            DatabaseUtils.appendEscapedSQLString(whereClause, "https://" + compareString);
            Browser.addOrUrlEquals(whereClause);
            DatabaseUtils.appendEscapedSQLString(whereClause, "https://www." + compareString);
        } else {
            whereClause = new StringBuilder("url = ");
            DatabaseUtils.appendEscapedSQLString(whereClause, compareString);
            Browser.addOrUrlEquals(whereClause);
            String wwwString = "www." + compareString;
            DatabaseUtils.appendEscapedSQLString(whereClause, wwwString);
            Browser.addOrUrlEquals(whereClause);
            DatabaseUtils.appendEscapedSQLString(whereClause, "http://" + compareString);
            Browser.addOrUrlEquals(whereClause);
            DatabaseUtils.appendEscapedSQLString(whereClause, "http://" + wwwString);
        }
        return cr.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "visits"}, whereClause.toString(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVisitedHistory(ContentResolver cr, String url, boolean real) {
        long now = System.currentTimeMillis();
        Cursor c = null;
        try {
            c = Browser.getVisitedLike(cr, url);
            if (c.moveToFirst()) {
                ContentValues values = new ContentValues();
                if (real) {
                    values.put("visits", c.getInt(1) + 1);
                } else {
                    values.put("user_entered", 1);
                }
                values.put("date", now);
                cr.update(ContentUris.withAppendedId(BrowserContract.History.CONTENT_URI, c.getLong(0)), values, null, null);
            } else {
                int user_entered;
                int visits;
                Browser.truncateHistory(cr);
                ContentValues values = new ContentValues();
                if (real) {
                    visits = 1;
                    user_entered = 0;
                } else {
                    visits = 0;
                    user_entered = 1;
                }
                values.put("url", url);
                values.put("visits", visits);
                values.put("date", now);
                values.put("title", url);
                values.put("created", 0);
                values.put("user_entered", user_entered);
                cr.insert(BrowserContract.History.CONTENT_URI, values);
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "updateVisitedHistory", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getVisitedHistory(ContentResolver cr) {
        Cursor c = null;
        String[] str = null;
        try {
            String[] projection = new String[]{"url"};
            c = cr.query(BrowserContract.History.CONTENT_URI, projection, "visits > 0", null, null);
            if (c == null) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            str = new String[c.getCount()];
            int i = 0;
            while (c.moveToNext()) {
                str[i] = c.getString(0);
                ++i;
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "getVisitedHistory", e);
            str = new String[]{};
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateHistory(ContentResolver cr) {
        block7: {
            Cursor cursor = null;
            try {
                cursor = cr.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "url", "date"}, null, null, "date ASC");
                if (!cursor.moveToFirst() || cursor.getCount() < 250) break block7;
                WebIconDatabase iconDb = WebIconDatabase.getInstance();
                for (int i = 0; i < 5; ++i) {
                    cr.delete(ContentUris.withAppendedId(BrowserContract.History.CONTENT_URI, cursor.getLong(0)), null, null);
                    iconDb.releaseIconForPageUrl(cursor.getString(1));
                    if (cursor.moveToNext()) continue;
                    break;
                }
            }
            catch (IllegalStateException e) {
                Log.e(LOGTAG, "truncateHistory", e);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canClearHistory(ContentResolver cr) {
        Cursor cursor = null;
        boolean ret = false;
        try {
            cursor = cr.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "visits"}, null, null, null);
            ret = cursor.getCount() > 0;
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "canClearHistory", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return ret;
    }

    public static void clearHistory(ContentResolver cr) {
        Browser.deleteHistoryWhere(cr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteHistoryWhere(ContentResolver cr, String whereClause) {
        Cursor cursor = null;
        try {
            cursor = cr.query(BrowserContract.History.CONTENT_URI, new String[]{"url"}, whereClause, null, null);
            if (cursor.moveToFirst()) {
                WebIconDatabase iconDb = WebIconDatabase.getInstance();
                do {
                    iconDb.releaseIconForPageUrl(cursor.getString(0));
                } while (cursor.moveToNext());
                cr.delete(BrowserContract.History.CONTENT_URI, whereClause, null);
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "deleteHistoryWhere", e);
            return;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public static void deleteHistoryTimeFrame(ContentResolver cr, long begin, long end) {
        String whereClause;
        String date = "date";
        if (-1L == begin) {
            if (-1L == end) {
                Browser.clearHistory(cr);
                return;
            }
            whereClause = date + " < " + Long.toString(end);
        } else {
            whereClause = -1L == end ? date + " >= " + Long.toString(begin) : date + " >= " + Long.toString(begin) + " AND " + date + " < " + Long.toString(end);
        }
        Browser.deleteHistoryWhere(cr, whereClause);
    }

    public static void deleteFromHistory(ContentResolver cr, String url) {
        cr.delete(BrowserContract.History.CONTENT_URI, "url=?", new String[]{url});
    }

    public static void addSearchUrl(ContentResolver cr, String search) {
        ContentValues values = new ContentValues();
        values.put("search", search);
        values.put("date", System.currentTimeMillis());
        cr.insert(BrowserContract.Searches.CONTENT_URI, values);
    }

    public static void clearSearches(ContentResolver cr) {
        try {
            cr.delete(BrowserContract.Searches.CONTENT_URI, null, null);
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "clearSearches", e);
        }
    }

    public static void requestAllIcons(ContentResolver cr, String where, WebIconDatabase.IconListener listener) {
        WebIconDatabase.getInstance().bulkRequestIconForPageUrl(cr, where, listener);
    }

    public static class SearchColumns
    implements BaseColumns {
        @Deprecated
        public static final String URL = "url";
        public static final String SEARCH = "search";
        public static final String DATE = "date";
    }

    public static class BookmarkColumns
    implements BaseColumns {
        public static final String URL = "url";
        public static final String VISITS = "visits";
        public static final String DATE = "date";
        public static final String BOOKMARK = "bookmark";
        public static final String TITLE = "title";
        public static final String CREATED = "created";
        public static final String FAVICON = "favicon";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TOUCH_ICON = "touch_icon";
        public static final String USER_ENTERED = "user_entered";
    }
}

