/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseIntArray;
import android.view.View;
import android.view.accessibility.AccessibilityInteractionClient;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibilityNodeInfo
implements Parcelable {
    private static final boolean DEBUG = false;
    public static final int ACTION_FOCUS = 1;
    public static final int ACTION_CLEAR_FOCUS = 2;
    public static final int ACTION_SELECT = 4;
    public static final int ACTION_CLEAR_SELECTION = 8;
    private static final int PROPERTY_CHECKABLE = 1;
    private static final int PROPERTY_CHECKED = 2;
    private static final int PROPERTY_FOCUSABLE = 4;
    private static final int PROPERTY_FOCUSED = 8;
    private static final int PROPERTY_SELECTED = 16;
    private static final int PROPERTY_CLICKABLE = 32;
    private static final int PROPERTY_LONG_CLICKABLE = 64;
    private static final int PROPERTY_ENABLED = 128;
    private static final int PROPERTY_PASSWORD = 256;
    private static final int PROPERTY_SCROLLABLE = 512;
    private static final int MAX_POOL_SIZE = 50;
    private static final Object sPoolLock = new Object();
    private static AccessibilityNodeInfo sPool;
    private static int sPoolSize;
    private AccessibilityNodeInfo mNext;
    private boolean mIsInPool;
    private boolean mSealed;
    private int mAccessibilityViewId = -1;
    private int mAccessibilityWindowId = -1;
    private int mParentAccessibilityViewId = -1;
    private int mBooleanProperties;
    private final Rect mBoundsInParent = new Rect();
    private final Rect mBoundsInScreen = new Rect();
    private CharSequence mPackageName;
    private CharSequence mClassName;
    private CharSequence mText;
    private CharSequence mContentDescription;
    private SparseIntArray mChildAccessibilityIds = new SparseIntArray();
    private int mActions;
    private IAccessibilityServiceConnection mConnection;
    public static final Parcelable.Creator<AccessibilityNodeInfo> CREATOR;

    private AccessibilityNodeInfo() {
    }

    public void setSource(View source) {
        this.enforceNotSealed();
        this.mAccessibilityViewId = source.getAccessibilityViewId();
        this.mAccessibilityWindowId = source.getAccessibilityWindowId();
    }

    public int getWindowId() {
        return this.mAccessibilityWindowId;
    }

    public int getChildCount() {
        return this.mChildAccessibilityIds.size();
    }

    public AccessibilityNodeInfo getChild(int index) {
        this.enforceSealed();
        int childAccessibilityViewId = this.mChildAccessibilityIds.get(index);
        if (!this.canPerformRequestOverConnection(childAccessibilityViewId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnection, this.mAccessibilityWindowId, childAccessibilityViewId);
    }

    public void addChild(View child) {
        this.enforceNotSealed();
        int childAccessibilityViewId = child.getAccessibilityViewId();
        int index = this.mChildAccessibilityIds.size();
        this.mChildAccessibilityIds.put(index, childAccessibilityViewId);
    }

    public int getActions() {
        return this.mActions;
    }

    public void addAction(int action) {
        this.enforceNotSealed();
        this.mActions |= action;
    }

    public boolean performAction(int action) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mAccessibilityViewId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.performAccessibilityAction(this.mConnection, this.mAccessibilityWindowId, this.mAccessibilityViewId, action);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String text) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mAccessibilityViewId)) {
            return Collections.emptyList();
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfosByViewText(this.mConnection, text, this.mAccessibilityWindowId, this.mAccessibilityViewId);
    }

    public AccessibilityNodeInfo getParent() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mAccessibilityViewId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnection, this.mAccessibilityWindowId, this.mParentAccessibilityViewId);
    }

    public void setParent(View parent) {
        this.enforceNotSealed();
        this.mParentAccessibilityViewId = parent.getAccessibilityViewId();
    }

    public void getBoundsInParent(Rect outBounds) {
        outBounds.set(this.mBoundsInParent.left, this.mBoundsInParent.top, this.mBoundsInParent.right, this.mBoundsInParent.bottom);
    }

    public void setBoundsInParent(Rect bounds) {
        this.enforceNotSealed();
        this.mBoundsInParent.set(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void getBoundsInScreen(Rect outBounds) {
        outBounds.set(this.mBoundsInScreen.left, this.mBoundsInScreen.top, this.mBoundsInScreen.right, this.mBoundsInScreen.bottom);
    }

    public void setBoundsInScreen(Rect bounds) {
        this.enforceNotSealed();
        this.mBoundsInScreen.set(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public boolean isCheckable() {
        return this.getBooleanProperty(1);
    }

    public void setCheckable(boolean checkable) {
        this.setBooleanProperty(1, checkable);
    }

    public boolean isChecked() {
        return this.getBooleanProperty(2);
    }

    public void setChecked(boolean checked) {
        this.setBooleanProperty(2, checked);
    }

    public boolean isFocusable() {
        return this.getBooleanProperty(4);
    }

    public void setFocusable(boolean focusable) {
        this.setBooleanProperty(4, focusable);
    }

    public boolean isFocused() {
        return this.getBooleanProperty(8);
    }

    public void setFocused(boolean focused) {
        this.setBooleanProperty(8, focused);
    }

    public boolean isSelected() {
        return this.getBooleanProperty(16);
    }

    public void setSelected(boolean selected) {
        this.setBooleanProperty(16, selected);
    }

    public boolean isClickable() {
        return this.getBooleanProperty(32);
    }

    public void setClickable(boolean clickable) {
        this.setBooleanProperty(32, clickable);
    }

    public boolean isLongClickable() {
        return this.getBooleanProperty(64);
    }

    public void setLongClickable(boolean longClickable) {
        this.setBooleanProperty(64, longClickable);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(128);
    }

    public void setEnabled(boolean enabled) {
        this.setBooleanProperty(128, enabled);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(256);
    }

    public void setPassword(boolean password) {
        this.setBooleanProperty(256, password);
    }

    public boolean isScrollable() {
        return this.getBooleanProperty(512);
    }

    public void setScrollable(boolean scrollable) {
        this.enforceNotSealed();
        this.setBooleanProperty(512, scrollable);
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(CharSequence packageName) {
        this.enforceNotSealed();
        this.mPackageName = packageName;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public void setClassName(CharSequence className) {
        this.enforceNotSealed();
        this.mClassName = className;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public void setText(CharSequence text) {
        this.enforceNotSealed();
        this.mText = text;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.enforceNotSealed();
        this.mContentDescription = contentDescription;
    }

    private boolean getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) != 0;
    }

    private void setBooleanProperty(int property, boolean value) {
        this.enforceNotSealed();
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    public void setConnection(IAccessibilityServiceConnection connection) {
        this.enforceNotSealed();
        this.mConnection = connection;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setSealed(boolean sealed) {
        this.mSealed = sealed;
    }

    public boolean isSealed() {
        return this.mSealed;
    }

    protected void enforceSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    protected void enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on an sealed instance.");
        }
    }

    public static AccessibilityNodeInfo obtain(View source) {
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
        info.setSource(source);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityNodeInfo obtain() {
        Object object = sPoolLock;
        synchronized (object) {
            if (sPool != null) {
                AccessibilityNodeInfo info = sPool;
                sPool = AccessibilityNodeInfo.sPool.mNext;
                --sPoolSize;
                info.mNext = null;
                info.mIsInPool = false;
                return info;
            }
            return new AccessibilityNodeInfo();
        }
    }

    public static AccessibilityNodeInfo obtain(AccessibilityNodeInfo info) {
        AccessibilityNodeInfo infoClone = AccessibilityNodeInfo.obtain();
        infoClone.init(info);
        return infoClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.mIsInPool) {
            throw new IllegalStateException("Info already recycled!");
        }
        this.clear();
        Object object = sPoolLock;
        synchronized (object) {
            if (sPoolSize <= 50) {
                this.mNext = sPool;
                sPool = this;
                this.mIsInPool = true;
                ++sPoolSize;
            }
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        if (this.mConnection == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(1);
            parcel.writeStrongBinder(this.mConnection.asBinder());
        }
        parcel.writeInt(this.isSealed() ? 1 : 0);
        parcel.writeInt(this.mAccessibilityViewId);
        parcel.writeInt(this.mAccessibilityWindowId);
        parcel.writeInt(this.mParentAccessibilityViewId);
        SparseIntArray childIds = this.mChildAccessibilityIds;
        int childIdsSize = childIds.size();
        parcel.writeInt(childIdsSize);
        for (int i = 0; i < childIdsSize; ++i) {
            parcel.writeInt(childIds.valueAt(i));
        }
        parcel.writeInt(this.mBoundsInParent.top);
        parcel.writeInt(this.mBoundsInParent.bottom);
        parcel.writeInt(this.mBoundsInParent.left);
        parcel.writeInt(this.mBoundsInParent.right);
        parcel.writeInt(this.mBoundsInScreen.top);
        parcel.writeInt(this.mBoundsInScreen.bottom);
        parcel.writeInt(this.mBoundsInScreen.left);
        parcel.writeInt(this.mBoundsInScreen.right);
        parcel.writeInt(this.mActions);
        parcel.writeInt(this.mBooleanProperties);
        TextUtils.writeToParcel(this.mPackageName, parcel, flags);
        TextUtils.writeToParcel(this.mClassName, parcel, flags);
        TextUtils.writeToParcel(this.mText, parcel, flags);
        TextUtils.writeToParcel(this.mContentDescription, parcel, flags);
        this.recycle();
    }

    private void init(AccessibilityNodeInfo other) {
        this.mSealed = other.mSealed;
        this.mConnection = other.mConnection;
        this.mAccessibilityViewId = other.mAccessibilityViewId;
        this.mParentAccessibilityViewId = other.mParentAccessibilityViewId;
        this.mAccessibilityWindowId = other.mAccessibilityWindowId;
        this.mBoundsInParent.set(other.mBoundsInParent);
        this.mBoundsInScreen.set(other.mBoundsInScreen);
        this.mPackageName = other.mPackageName;
        this.mClassName = other.mClassName;
        this.mText = other.mText;
        this.mContentDescription = other.mContentDescription;
        this.mActions = other.mActions;
        this.mBooleanProperties = other.mBooleanProperties;
        this.mChildAccessibilityIds = other.mChildAccessibilityIds.clone();
    }

    private void initFromParcel(Parcel parcel) {
        if (parcel.readInt() == 1) {
            this.mConnection = IAccessibilityServiceConnection.Stub.asInterface(parcel.readStrongBinder());
        }
        this.mSealed = parcel.readInt() == 1;
        this.mAccessibilityViewId = parcel.readInt();
        this.mAccessibilityWindowId = parcel.readInt();
        this.mParentAccessibilityViewId = parcel.readInt();
        SparseIntArray childIds = this.mChildAccessibilityIds;
        int childrenSize = parcel.readInt();
        for (int i = 0; i < childrenSize; ++i) {
            int childId = parcel.readInt();
            childIds.put(i, childId);
        }
        this.mBoundsInParent.top = parcel.readInt();
        this.mBoundsInParent.bottom = parcel.readInt();
        this.mBoundsInParent.left = parcel.readInt();
        this.mBoundsInParent.right = parcel.readInt();
        this.mBoundsInScreen.top = parcel.readInt();
        this.mBoundsInScreen.bottom = parcel.readInt();
        this.mBoundsInScreen.left = parcel.readInt();
        this.mBoundsInScreen.right = parcel.readInt();
        this.mActions = parcel.readInt();
        this.mBooleanProperties = parcel.readInt();
        this.mPackageName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mClassName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
    }

    private void clear() {
        this.mSealed = false;
        this.mConnection = null;
        this.mAccessibilityViewId = -1;
        this.mParentAccessibilityViewId = -1;
        this.mAccessibilityWindowId = -1;
        this.mChildAccessibilityIds.clear();
        this.mBoundsInParent.set(0, 0, 0, 0);
        this.mBoundsInScreen.set(0, 0, 0, 0);
        this.mBooleanProperties = 0;
        this.mPackageName = null;
        this.mClassName = null;
        this.mText = null;
        this.mContentDescription = null;
        this.mActions = 0;
    }

    private static String getActionSymbolicName(int action) {
        switch (action) {
            case 1: {
                return "ACTION_FOCUS";
            }
            case 2: {
                return "ACTION_CLEAR_FOCUS";
            }
            case 4: {
                return "ACTION_SELECT";
            }
            case 8: {
                return "ACTION_CLEAR_SELECTION";
            }
        }
        throw new IllegalArgumentException("Unknown action: " + action);
    }

    private boolean canPerformRequestOverConnection(int accessibilityViewId) {
        return this.mAccessibilityWindowId != -1 && accessibilityViewId != -1 && this.mConnection != null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AccessibilityNodeInfo other = (AccessibilityNodeInfo)object;
        if (this.mAccessibilityViewId != other.mAccessibilityViewId) {
            return false;
        }
        return this.mAccessibilityWindowId == other.mAccessibilityWindowId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mAccessibilityViewId;
        result = 31 * result + this.mAccessibilityWindowId;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("; boundsInParent: " + this.mBoundsInParent);
        builder.append("; boundsInScreen: " + this.mBoundsInScreen);
        builder.append("; packageName: ").append(this.mPackageName);
        builder.append("; className: ").append(this.mClassName);
        builder.append("; text: ").append(this.mText);
        builder.append("; contentDescription: ").append(this.mContentDescription);
        builder.append("; checkable: ").append(this.isCheckable());
        builder.append("; checked: ").append(this.isChecked());
        builder.append("; focusable: ").append(this.isFocusable());
        builder.append("; focused: ").append(this.isFocused());
        builder.append("; selected: ").append(this.isSelected());
        builder.append("; clickable: ").append(this.isClickable());
        builder.append("; longClickable: ").append(this.isLongClickable());
        builder.append("; enabled: ").append(this.isEnabled());
        builder.append("; password: ").append(this.isPassword());
        builder.append("; scrollable: " + this.isScrollable());
        builder.append("; [");
        int actionBits = this.mActions;
        while (actionBits != 0) {
            int action = 1 << Integer.numberOfTrailingZeros(actionBits);
            builder.append(AccessibilityNodeInfo.getActionSymbolicName(action));
            if ((actionBits &= ~action) == 0) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    static {
        CREATOR = new Parcelable.Creator<AccessibilityNodeInfo>(){

            @Override
            public AccessibilityNodeInfo createFromParcel(Parcel parcel) {
                AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
                info.initFromParcel(parcel);
                return info;
            }

            public AccessibilityNodeInfo[] newArray(int size) {
                return new AccessibilityNodeInfo[size];
            }
        };
    }
}

