/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;

public class TargetDrawable {
    private static final String TAG = "TargetDrawable";
    private static final boolean DEBUG = false;
    public static final int[] STATE_ACTIVE = new int[]{16842910, 16842914};
    public static final int[] STATE_INACTIVE = new int[]{16842910, -16842914};
    public static final int[] STATE_FOCUSED = new int[]{16842910, 16842908};
    private float mTranslationX = 0.0f;
    private float mTranslationY = 0.0f;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mAlpha = 1.0f;
    private Drawable mDrawable;

    public TargetDrawable(Resources res, int resId) {
        this(res, resId == 0 ? null : res.getDrawable(resId));
    }

    public TargetDrawable(Resources res, Drawable drawable2) {
        this.mDrawable = drawable2 != null ? drawable2.mutate() : null;
        this.resizeDrawables();
        this.setState(STATE_INACTIVE);
    }

    public void setState(int[] state) {
        if (this.mDrawable instanceof StateListDrawable) {
            StateListDrawable d = (StateListDrawable)this.mDrawable;
            d.setState(state);
        }
    }

    public boolean hasState(int[] state) {
        if (this.mDrawable instanceof StateListDrawable) {
            StateListDrawable d = (StateListDrawable)this.mDrawable;
            return d.getStateDrawableIndex(state) != -1;
        }
        return false;
    }

    public boolean isActive() {
        if (this.mDrawable instanceof StateListDrawable) {
            StateListDrawable d = (StateListDrawable)this.mDrawable;
            int[] states = d.getState();
            for (int i = 0; i < states.length; ++i) {
                if (states[i] != 16842908) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.mDrawable != null;
    }

    private void resizeDrawables() {
        if (this.mDrawable instanceof StateListDrawable) {
            Drawable childDrawable;
            int i;
            StateListDrawable d = (StateListDrawable)this.mDrawable;
            int maxWidth = 0;
            int maxHeight = 0;
            for (i = 0; i < d.getStateCount(); ++i) {
                childDrawable = d.getStateDrawable(i);
                maxWidth = Math.max(maxWidth, childDrawable.getIntrinsicWidth());
                maxHeight = Math.max(maxHeight, childDrawable.getIntrinsicHeight());
            }
            d.setBounds(0, 0, maxWidth, maxHeight);
            for (i = 0; i < d.getStateCount(); ++i) {
                childDrawable = d.getStateDrawable(i);
                childDrawable.setBounds(0, 0, maxWidth, maxHeight);
            }
        } else if (this.mDrawable != null) {
            this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }
    }

    public void setX(float x) {
        this.mTranslationX = x;
    }

    public void setY(float y) {
        this.mTranslationY = y;
    }

    public void setScaleX(float x) {
        this.mScaleX = x;
    }

    public void setScaleY(float y) {
        this.mScaleY = y;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public float getX() {
        return this.mTranslationX;
    }

    public float getY() {
        return this.mTranslationY;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public int getWidth() {
        return this.mDrawable != null ? this.mDrawable.getIntrinsicWidth() : 0;
    }

    public int getHeight() {
        return this.mDrawable != null ? this.mDrawable.getIntrinsicHeight() : 0;
    }

    public void draw(Canvas canvas) {
        if (this.mDrawable == null) {
            return;
        }
        canvas.save(1);
        canvas.translate(this.mTranslationX, this.mTranslationY);
        canvas.scale(this.mScaleX, this.mScaleY);
        canvas.translate(-0.5f * (float)this.getWidth(), -0.5f * (float)this.getHeight());
        this.mDrawable.setAlpha(Math.round(this.mAlpha * 255.0f));
        this.mDrawable.draw(canvas);
        canvas.restore();
    }

    static class DrawableWithAlpha
    extends Drawable {
        private float mAlpha = 1.0f;
        private Drawable mRealDrawable;

        public DrawableWithAlpha(Drawable realDrawable) {
            this.mRealDrawable = realDrawable;
        }

        public void setAlpha(float alpha) {
            this.mAlpha = alpha;
        }

        public float getAlpha() {
            return this.mAlpha;
        }

        public void draw(Canvas canvas) {
            this.mRealDrawable.setAlpha(Math.round(this.mAlpha * 255.0f));
            this.mRealDrawable.draw(canvas);
        }

        public void setAlpha(int alpha) {
            this.mRealDrawable.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter cf) {
            this.mRealDrawable.setColorFilter(cf);
        }

        public int getOpacity() {
            return this.mRealDrawable.getOpacity();
        }
    }
}

