/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import javax.net.ssl.SSLSession;
import org.apache.harmony.xnet.provider.jsse.AbstractSessionContext;
import org.apache.harmony.xnet.provider.jsse.SSLServerSessionCache;

public class ServerSessionContext
extends AbstractSessionContext {
    private SSLServerSessionCache persistentCache;

    public ServerSessionContext() {
        super(100, 0);
    }

    public void setPersistentCache(SSLServerSessionCache persistentCache) {
        this.persistentCache = persistentCache;
    }

    protected void sessionRemoved(SSLSession session) {
    }

    public SSLSession getSession(byte[] sessionId) {
        byte[] data;
        SSLSession session = super.getSession(sessionId);
        if (session != null) {
            return session;
        }
        if (this.persistentCache != null && (data = this.persistentCache.getSessionData(sessionId)) != null && (session = this.toSession(data, null, -1)) != null && session.isValid()) {
            super.putSession(session);
            return session;
        }
        return null;
    }

    void putSession(SSLSession session) {
        byte[] data;
        super.putSession(session);
        if (this.persistentCache != null && (data = this.toBytes(session)) != null) {
            this.persistentCache.putSessionData(session, data);
        }
    }
}

