/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.ContextImpl;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.ManifestDigest;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApplicationPackageManager
extends PackageManager {
    private static final String TAG = "ApplicationPackageManager";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_ICONS = false;
    int mCachedSafeMode = -1;
    private final ContextImpl mContext;
    private final IPackageManager mPM;
    private static final Object sSync = new Object();
    private static HashMap<ResourceName, WeakReference<Drawable.ConstantState>> sIconCache = new HashMap();
    private static HashMap<ResourceName, WeakReference<CharSequence>> sStringCache = new HashMap();

    @Override
    public PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        try {
            PackageInfo pi = this.mPM.getPackageInfo(packageName, flags);
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Override
    public String[] currentToCanonicalPackageNames(String[] names) {
        try {
            return this.mPM.currentToCanonicalPackageNames(names);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public String[] canonicalToCurrentPackageNames(String[] names) {
        try {
            return this.mPM.canonicalToCurrentPackageNames(names);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public Intent getLaunchIntentForPackage(String packageName) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory("android.intent.category.INFO");
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, 0);
        if (ris == null || ris.size() <= 0) {
            intentToResolve.removeCategory("android.intent.category.INFO");
            intentToResolve.addCategory("android.intent.category.LAUNCHER");
            intentToResolve.setPackage(packageName);
            ris = this.queryIntentActivities(intentToResolve, 0);
        }
        if (ris == null || ris.size() <= 0) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(ris.get((int)0).activityInfo.packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    @Override
    public int[] getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
        try {
            int[] gids = this.mPM.getPackageGids(packageName);
            if (gids == null || gids.length > 0) {
                return gids;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Override
    public PermissionInfo getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        try {
            PermissionInfo pi = this.mPM.getPermissionInfo(name, flags);
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Override
    public List<PermissionInfo> queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
        try {
            List<PermissionInfo> pi = this.mPM.queryPermissionsByGroup(group, flags);
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(group);
    }

    @Override
    public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        try {
            PermissionGroupInfo pgi = this.mPM.getPermissionGroupInfo(name, flags);
            if (pgi != null) {
                return pgi;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Override
    public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        try {
            return this.mPM.getAllPermissionGroups(flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        try {
            ApplicationInfo ai = this.mPM.getApplicationInfo(packageName, flags);
            if (ai != null) {
                return ai;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Override
    public ActivityInfo getActivityInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            ActivityInfo ai = this.mPM.getActivityInfo(className, flags);
            if (ai != null) {
                return ai;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public ActivityInfo getReceiverInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            ActivityInfo ai = this.mPM.getReceiverInfo(className, flags);
            if (ai != null) {
                return ai;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public ServiceInfo getServiceInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            ServiceInfo si = this.mPM.getServiceInfo(className, flags);
            if (si != null) {
                return si;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public ProviderInfo getProviderInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            ProviderInfo pi = this.mPM.getProviderInfo(className, flags);
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public String[] getSystemSharedLibraryNames() {
        try {
            return this.mPM.getSystemSharedLibraryNames();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public FeatureInfo[] getSystemAvailableFeatures() {
        try {
            return this.mPM.getSystemAvailableFeatures();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public boolean hasSystemFeature(String name) {
        try {
            return this.mPM.hasSystemFeature(name);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public int checkPermission(String permName, String pkgName) {
        try {
            return this.mPM.checkPermission(permName, pkgName);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public boolean addPermission(PermissionInfo info) {
        try {
            return this.mPM.addPermission(info);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public boolean addPermissionAsync(PermissionInfo info) {
        try {
            return this.mPM.addPermissionAsync(info);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public void removePermission(String name) {
        try {
            this.mPM.removePermission(name);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public int checkSignatures(String pkg1, String pkg2) {
        try {
            return this.mPM.checkSignatures(pkg1, pkg2);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public int checkSignatures(int uid1, int uid2) {
        try {
            return this.mPM.checkUidSignatures(uid1, uid2);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public String[] getPackagesForUid(int uid) {
        try {
            return this.mPM.getPackagesForUid(uid);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public String getNameForUid(int uid) {
        try {
            return this.mPM.getNameForUid(uid);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public int getUidForSharedUser(String sharedUserName) throws PackageManager.NameNotFoundException {
        try {
            int uid = this.mPM.getUidForSharedUser(sharedUserName);
            if (uid != -1) {
                return uid;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException("No shared userid for user:" + sharedUserName);
    }

    @Override
    public List<PackageInfo> getInstalledPackages(int flags) {
        try {
            ParceledListSlice slice;
            ArrayList<PackageInfo> packageInfos = new ArrayList<PackageInfo>();
            PackageInfo lastItem = null;
            do {
                String lastKey = lastItem != null ? lastItem.packageName : null;
                slice = this.mPM.getInstalledPackages(flags, lastKey);
                lastItem = slice.populateList(packageInfos, PackageInfo.CREATOR);
            } while (!slice.isLastSlice());
            return packageInfos;
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public List<ApplicationInfo> getInstalledApplications(int flags) {
        try {
            ParceledListSlice slice;
            ArrayList<ApplicationInfo> applicationInfos = new ArrayList<ApplicationInfo>();
            ApplicationInfo lastItem = null;
            do {
                String lastKey = lastItem != null ? lastItem.packageName : null;
                slice = this.mPM.getInstalledApplications(flags, lastKey);
                lastItem = slice.populateList(applicationInfos, ApplicationInfo.CREATOR);
            } while (!slice.isLastSlice());
            return applicationInfos;
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public ResolveInfo resolveActivity(Intent intent, int flags) {
        try {
            return this.mPM.resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        try {
            return this.mPM.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
        ContentResolver resolver = this.mContext.getContentResolver();
        String[] specificTypes = null;
        if (specifics != null) {
            int N = specifics.length;
            for (int i = 0; i < N; ++i) {
                String t;
                Intent sp = specifics[i];
                if (sp == null || (t = sp.resolveTypeIfNeeded(resolver)) == null) continue;
                if (specificTypes == null) {
                    specificTypes = new String[N];
                }
                specificTypes[i] = t;
            }
        }
        try {
            return this.mPM.queryIntentActivityOptions(caller, specifics, specificTypes, intent, intent.resolveTypeIfNeeded(resolver), flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        try {
            return this.mPM.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public ResolveInfo resolveService(Intent intent, int flags) {
        try {
            return this.mPM.resolveService(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        try {
            return this.mPM.queryIntentServices(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public ProviderInfo resolveContentProvider(String name, int flags) {
        try {
            return this.mPM.resolveContentProvider(name, flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        try {
            return this.mPM.queryContentProviders(processName, uid, flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            InstrumentationInfo ii = this.mPM.getInstrumentationInfo(className, flags);
            if (ii != null) {
                return ii;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        try {
            return this.mPM.queryInstrumentation(targetPackage, flags);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    @Override
    public Drawable getDrawable(String packageName, int resid, ApplicationInfo appInfo) {
        ResourceName name = new ResourceName(packageName, resid);
        Drawable dr = this.getCachedIcon(name);
        if (dr != null) {
            return dr;
        }
        if (appInfo == null) {
            try {
                appInfo = this.getApplicationInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        try {
            Resources r = this.getResourcesForApplication(appInfo);
            dr = r.getDrawable(resid);
            this.putCachedIcon(name, dr);
            return dr;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("PackageManager", "Failure retrieving resources for" + appInfo.packageName);
        }
        catch (Resources.NotFoundException e) {
            Log.w("PackageManager", "Failure retrieving resources for" + appInfo.packageName + ": " + e.getMessage());
        }
        catch (RuntimeException e) {
            Log.w("PackageManager", "Failure retrieving icon 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
        }
        return null;
    }

    @Override
    public Drawable getActivityIcon(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(activityName, 0).loadIcon(this);
    }

    @Override
    public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityIcon(intent.getComponent());
        }
        ResolveInfo info = this.resolveActivity(intent, 65536);
        if (info != null) {
            return info.activityInfo.loadIcon(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    @Override
    public Drawable getDefaultActivityIcon() {
        return Resources.getSystem().getDrawable(17301651);
    }

    @Override
    public Drawable getApplicationIcon(ApplicationInfo info) {
        return info.loadIcon(this);
    }

    @Override
    public Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
        return this.getApplicationIcon(this.getApplicationInfo(packageName, 0));
    }

    @Override
    public Drawable getActivityLogo(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(activityName, 0).loadLogo(this);
    }

    @Override
    public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityLogo(intent.getComponent());
        }
        ResolveInfo info = this.resolveActivity(intent, 65536);
        if (info != null) {
            return info.activityInfo.loadLogo(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    @Override
    public Drawable getApplicationLogo(ApplicationInfo info) {
        return info.loadLogo(this);
    }

    @Override
    public Drawable getApplicationLogo(String packageName) throws PackageManager.NameNotFoundException {
        return this.getApplicationLogo(this.getApplicationInfo(packageName, 0));
    }

    @Override
    public Resources getResourcesForActivity(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(this.getActivityInfo((ComponentName)activityName, (int)0).applicationInfo);
    }

    @Override
    public Resources getResourcesForApplication(ApplicationInfo app) throws PackageManager.NameNotFoundException {
        if (app.packageName.equals("system")) {
            return this.mContext.mMainThread.getSystemContext().getResources();
        }
        Resources r = this.mContext.mMainThread.getTopLevelResources(app.uid == Process.myUid() ? app.sourceDir : app.publicSourceDir, this.mContext.mPackageInfo);
        if (r != null) {
            return r;
        }
        throw new PackageManager.NameNotFoundException("Unable to open " + app.publicSourceDir);
    }

    @Override
    public Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(this.getApplicationInfo(appPackageName, 0));
    }

    @Override
    public boolean isSafeMode() {
        try {
            if (this.mCachedSafeMode < 0) {
                this.mCachedSafeMode = this.mPM.isSafeMode() ? 1 : 0;
            }
            return this.mCachedSafeMode != 0;
        }
        catch (RemoteException e) {
            throw new RuntimeException("Package manager has died", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void configurationChanged() {
        Object object = sSync;
        synchronized (object) {
            sIconCache.clear();
            sStringCache.clear();
        }
    }

    ApplicationPackageManager(ContextImpl context, IPackageManager pm) {
        this.mContext = context;
        this.mPM = pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable getCachedIcon(ResourceName name) {
        Object object = sSync;
        synchronized (object) {
            WeakReference<Drawable.ConstantState> wr = sIconCache.get(name);
            if (wr != null) {
                Drawable.ConstantState state = (Drawable.ConstantState)wr.get();
                if (state != null) {
                    return state.newDrawable();
                }
                sIconCache.remove(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedIcon(ResourceName name, Drawable dr) {
        Object object = sSync;
        synchronized (object) {
            sIconCache.put(name, new WeakReference<Drawable.ConstantState>(dr.getConstantState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handlePackageBroadcast(int cmd, String[] pkgList, boolean hasPkgInfo) {
        boolean immediateGc = false;
        if (cmd == 1) {
            immediateGc = true;
        }
        if (pkgList != null && pkgList.length > 0) {
            boolean needCleanup = false;
            for (String ssp : pkgList) {
                Object object = sSync;
                synchronized (object) {
                    ResourceName nm;
                    Iterator<ResourceName> it;
                    if (sIconCache.size() > 0) {
                        it = sIconCache.keySet().iterator();
                        while (it.hasNext()) {
                            nm = it.next();
                            if (!nm.packageName.equals(ssp)) continue;
                            it.remove();
                            needCleanup = true;
                        }
                    }
                    if (sStringCache.size() > 0) {
                        it = sStringCache.keySet().iterator();
                        while (it.hasNext()) {
                            nm = it.next();
                            if (!nm.packageName.equals(ssp)) continue;
                            it.remove();
                            needCleanup = true;
                        }
                    }
                }
            }
            if (needCleanup || hasPkgInfo) {
                if (immediateGc) {
                    Runtime.getRuntime().gc();
                } else {
                    ActivityThread.currentActivityThread().scheduleGcIdler();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence getCachedString(ResourceName name) {
        Object object = sSync;
        synchronized (object) {
            WeakReference<CharSequence> wr = sStringCache.get(name);
            if (wr != null) {
                CharSequence cs = (CharSequence)wr.get();
                if (cs != null) {
                    return cs;
                }
                sStringCache.remove(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedString(ResourceName name, CharSequence cs) {
        Object object = sSync;
        synchronized (object) {
            sStringCache.put(name, new WeakReference<CharSequence>(cs));
        }
    }

    @Override
    public CharSequence getText(String packageName, int resid, ApplicationInfo appInfo) {
        ResourceName name = new ResourceName(packageName, resid);
        CharSequence text = this.getCachedString(name);
        if (text != null) {
            return text;
        }
        if (appInfo == null) {
            try {
                appInfo = this.getApplicationInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        try {
            Resources r = this.getResourcesForApplication(appInfo);
            text = r.getText(resid);
            this.putCachedString(name, text);
            return text;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("PackageManager", "Failure retrieving resources for" + appInfo.packageName);
        }
        catch (RuntimeException e) {
            Log.w("PackageManager", "Failure retrieving text 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
        }
        return null;
    }

    @Override
    public XmlResourceParser getXml(String packageName, int resid, ApplicationInfo appInfo) {
        if (appInfo == null) {
            try {
                appInfo = this.getApplicationInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        try {
            Resources r = this.getResourcesForApplication(appInfo);
            return r.getXml(resid);
        }
        catch (RuntimeException e) {
            Log.w("PackageManager", "Failure retrieving xml 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("PackageManager", "Failure retrieving resources for " + appInfo.packageName);
        }
        return null;
    }

    @Override
    public CharSequence getApplicationLabel(ApplicationInfo info) {
        return info.loadLabel(this);
    }

    @Override
    public void installPackage(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName) {
        try {
            this.mPM.installPackage(packageURI, observer, flags, installerPackageName);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public void installPackageWithVerification(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName, Uri verificationURI, ManifestDigest manifestDigest) {
        try {
            this.mPM.installPackageWithVerification(packageURI, observer, flags, installerPackageName, verificationURI, manifestDigest);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public void verifyPendingInstall(int id2, int response) {
        try {
            this.mPM.verifyPendingInstall(id2, response);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setInstallerPackageName(String targetPackage, String installerPackageName) {
        try {
            this.mPM.setInstallerPackageName(targetPackage, installerPackageName);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void movePackage(String packageName, IPackageMoveObserver observer, int flags) {
        try {
            this.mPM.movePackage(packageName, observer, flags);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public String getInstallerPackageName(String packageName) {
        try {
            return this.mPM.getInstallerPackageName(packageName);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        try {
            this.mPM.deletePackage(packageName, observer, flags);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public void clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        try {
            this.mPM.clearApplicationUserData(packageName, observer);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
        try {
            this.mPM.deleteApplicationCacheFiles(packageName, observer);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void freeStorageAndNotify(long idealStorageSize, IPackageDataObserver observer) {
        try {
            this.mPM.freeStorageAndNotify(idealStorageSize, observer);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public void freeStorage(long freeStorageSize, IntentSender pi) {
        try {
            this.mPM.freeStorage(freeStorageSize, pi);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public void getPackageSizeInfo(String packageName, IPackageStatsObserver observer) {
        try {
            this.mPM.getPackageSizeInfo(packageName, observer);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void addPackageToPreferred(String packageName) {
        try {
            this.mPM.addPackageToPreferred(packageName);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void removePackageFromPreferred(String packageName) {
        try {
            this.mPM.removePackageFromPreferred(packageName);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public List<PackageInfo> getPreferredPackages(int flags) {
        try {
            return this.mPM.getPreferredPackages(flags);
        }
        catch (RemoteException remoteException) {
            return new ArrayList<PackageInfo>();
        }
    }

    @Override
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        try {
            this.mPM.addPreferredActivity(filter, match, set, activity);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        try {
            this.mPM.replacePreferredActivity(filter, match, set, activity);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public void clearPackagePreferredActivities(String packageName) {
        try {
            this.mPM.clearPackagePreferredActivities(packageName);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        try {
            return this.mPM.getPreferredActivities(outFilters, outActivities, packageName);
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        try {
            this.mPM.setComponentEnabledSetting(componentName, newState, flags);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public int getComponentEnabledSetting(ComponentName componentName) {
        try {
            return this.mPM.getComponentEnabledSetting(componentName);
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    @Override
    public void setApplicationEnabledSetting(String packageName, int newState, int flags) {
        try {
            this.mPM.setApplicationEnabledSetting(packageName, newState, flags);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    @Override
    public int getApplicationEnabledSetting(String packageName) {
        try {
            return this.mPM.getApplicationEnabledSetting(packageName);
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    @Override
    public UserInfo createUser(String name, int flags) {
        try {
            return this.mPM.createUser(name, flags);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public List<UserInfo> getUsers() {
        ArrayList<UserInfo> users = new ArrayList<UserInfo>();
        UserInfo primary = new UserInfo(0, "Root!", 3);
        users.add(primary);
        return users;
    }

    @Override
    public boolean removeUser(int id2) {
        try {
            return this.mPM.removeUser(id2);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public void updateUserName(int id2, String name) {
    }

    @Override
    public void updateUserFlags(int id2, int flags) {
    }

    @Override
    public VerifierDeviceIdentity getVerifierDeviceIdentity() {
        try {
            return this.mPM.getVerifierDeviceIdentity();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private static class ResourceName {
        final String packageName;
        final int iconId;

        ResourceName(String _packageName, int _iconId) {
            this.packageName = _packageName;
            this.iconId = _iconId;
        }

        ResourceName(ApplicationInfo aInfo, int _iconId) {
            this(aInfo.packageName, _iconId);
        }

        ResourceName(ComponentInfo cInfo, int _iconId) {
            this(cInfo.applicationInfo.packageName, _iconId);
        }

        ResourceName(ResolveInfo rInfo, int _iconId) {
            this(rInfo.activityInfo.applicationInfo.packageName, _iconId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceName that = (ResourceName)o;
            if (this.iconId != that.iconId) {
                return false;
            }
            return !(this.packageName == null ? that.packageName != null : !this.packageName.equals(that.packageName));
        }

        public int hashCode() {
            int result = this.packageName.hashCode();
            result = 31 * result + this.iconId;
            return result;
        }

        public String toString() {
            return "{ResourceName " + this.packageName + " / " + this.iconId + "}";
        }
    }
}

