/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkState;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.android.internal.util.Objects;

public class NetworkIdentity {
    final int mType;
    final int mSubType;
    final String mSubscriberId;
    final boolean mRoaming;

    public NetworkIdentity(int type, int subType, String subscriberId, boolean roaming) {
        this.mType = type;
        this.mSubType = subType;
        this.mSubscriberId = subscriberId;
        this.mRoaming = roaming;
    }

    public int hashCode() {
        return Objects.hashCode(this.mType, this.mSubType, this.mSubscriberId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkIdentity) {
            NetworkIdentity ident = (NetworkIdentity)obj;
            return this.mType == ident.mType && this.mSubType == ident.mSubType && Objects.equal(this.mSubscriberId, ident.mSubscriberId) && this.mRoaming == ident.mRoaming;
        }
        return false;
    }

    public String toString() {
        String typeName = ConnectivityManager.getNetworkTypeName(this.mType);
        String subTypeName = ConnectivityManager.isNetworkTypeMobile(this.mType) ? TelephonyManager.getNetworkTypeName(this.mSubType) : Integer.toString(this.mSubType);
        String scrubSubscriberId = NetworkIdentity.scrubSubscriberId(this.mSubscriberId);
        String roaming = this.mRoaming ? ", ROAMING" : "";
        return "[type=" + typeName + ", subType=" + subTypeName + ", subscriberId=" + scrubSubscriberId + roaming + "]";
    }

    public int getType() {
        return this.mType;
    }

    public int getSubType() {
        return this.mSubType;
    }

    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public boolean getRoaming() {
        return this.mRoaming;
    }

    public static String scrubSubscriberId(String subscriberId) {
        if ("eng".equals(Build.TYPE)) {
            return subscriberId;
        }
        return subscriberId != null ? "valid" : "null";
    }

    public static NetworkIdentity buildNetworkIdentity(Context context, NetworkState state) {
        String subscriberId;
        boolean roaming;
        int type = state.networkInfo.getType();
        int subType = state.networkInfo.getSubtype();
        if (ConnectivityManager.isNetworkTypeMobile(type)) {
            TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
            roaming = telephony.isNetworkRoaming();
            subscriberId = state.subscriberId != null ? state.subscriberId : telephony.getSubscriberId();
        } else {
            subscriberId = null;
            roaming = false;
        }
        return new NetworkIdentity(type, subType, subscriberId, roaming);
    }
}

