/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HandlerThread_Delegate {
    private static Map<BridgeContext, List<HandlerThread>> sThreads = new HashMap<BridgeContext, List<HandlerThread>>();

    public static void cleanUp(BridgeContext bridgeContext) {
        List<HandlerThread> list = sThreads.get(bridgeContext);
        if (list != null) {
            for (HandlerThread handlerThread : list) {
                handlerThread.quit();
            }
            list.clear();
            sThreads.remove(bridgeContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static void run(HandlerThread handlerThread) {
        BridgeContext bridgeContext = RenderAction.getCurrentContext();
        List<HandlerThread> list = sThreads.get(bridgeContext);
        if (list == null) {
            list = new ArrayList<HandlerThread>();
            sThreads.put(bridgeContext, list);
        }
        list.add(handlerThread);
        handlerThread.mTid = Process.myTid();
        Looper.prepare();
        HandlerThread handlerThread2 = handlerThread;
        synchronized (handlerThread2) {
            handlerThread.mLooper = Looper.myLooper();
            handlerThread.notifyAll();
        }
        Process.setThreadPriority(handlerThread.mPriority);
        handlerThread.onLooperPrepared();
        Looper.loop();
        handlerThread.mTid = -1;
    }
}

