/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.PrefixPrinter;
import android.util.Printer;

public class Looper {
    private static final String TAG = "Looper";
    static final ThreadLocal<Looper> sThreadLocal = new ThreadLocal();
    final MessageQueue mQueue = new MessageQueue();
    final Thread mThread = Thread.currentThread();
    volatile boolean mRun = true;
    private Printer mLogging = null;
    private static Looper mMainLooper = null;

    public static void prepare() {
        if (sThreadLocal.get() != null) {
            throw new RuntimeException("Only one Looper may be created per thread");
        }
        sThreadLocal.set(new Looper());
    }

    public static void prepareMainLooper() {
        Looper.prepare();
        Looper.setMainLooper(Looper.myLooper());
        Looper.myLooper().mQueue.mQuitAllowed = false;
    }

    private static synchronized void setMainLooper(Looper looper) {
        mMainLooper = looper;
    }

    public static synchronized Looper getMainLooper() {
        return mMainLooper;
    }

    public static void loop() {
        Looper me = Looper.myLooper();
        if (me == null) {
            throw new RuntimeException("No Looper; Looper.prepare() wasn't called on this thread.");
        }
        MessageQueue queue = me.mQueue;
        Binder.clearCallingIdentity();
        long ident = Binder.clearCallingIdentity();
        while (true) {
            long newIdent;
            Message msg;
            if ((msg = queue.next()) == null) {
                continue;
            }
            if (msg.target == null) {
                return;
            }
            long wallStart = 0L;
            long threadStart = 0L;
            Printer logging = me.mLogging;
            if (logging != null) {
                logging.println(">>>>> Dispatching to " + msg.target + " " + msg.callback + ": " + msg.what);
                wallStart = SystemClock.currentTimeMicro();
                threadStart = SystemClock.currentThreadTimeMicro();
            }
            msg.target.dispatchMessage(msg);
            if (logging != null) {
                long wallTime = SystemClock.currentTimeMicro() - wallStart;
                long threadTime = SystemClock.currentThreadTimeMicro() - threadStart;
                logging.println("<<<<< Finished to " + msg.target + " " + msg.callback);
                if (logging instanceof Profiler) {
                    ((Profiler)((Object)logging)).profile(msg, wallStart, wallTime, threadStart, threadTime);
                }
            }
            if (ident != (newIdent = Binder.clearCallingIdentity())) {
                Log.wtf(TAG, "Thread identity changed from 0x" + Long.toHexString(ident) + " to 0x" + Long.toHexString(newIdent) + " while dispatching to " + msg.target.getClass().getName() + " " + msg.callback + " what=" + msg.what);
            }
            msg.recycle();
        }
    }

    public static Looper myLooper() {
        return sThreadLocal.get();
    }

    public void setMessageLogging(Printer printer) {
        this.mLogging = printer;
    }

    public static MessageQueue myQueue() {
        return Looper.myLooper().mQueue;
    }

    private Looper() {
    }

    public void quit() {
        Message msg = Message.obtain();
        this.mQueue.enqueueMessage(msg, 0L);
    }

    public Thread getThread() {
        return this.mThread;
    }

    public MessageQueue getQueue() {
        return this.mQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Printer pw, String prefix) {
        pw = PrefixPrinter.create(pw, prefix);
        pw.println(this.toString());
        pw.println("mRun=" + this.mRun);
        pw.println("mThread=" + this.mThread);
        pw.println("mQueue=" + (this.mQueue != null ? this.mQueue : "(null"));
        if (this.mQueue != null) {
            MessageQueue messageQueue = this.mQueue;
            synchronized (messageQueue) {
                long now = SystemClock.uptimeMillis();
                Message msg = this.mQueue.mMessages;
                int n = 0;
                while (msg != null) {
                    pw.println("  Message " + n + ": " + msg.toString(now));
                    ++n;
                    msg = msg.next;
                }
                pw.println("(Total messages: " + n + ")");
            }
        }
    }

    public String toString() {
        return "Looper{" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    public static interface Profiler {
        public void profile(Message var1, long var2, long var4, long var6, long var8);
    }
}

