/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.text.Editable;
import android.text.Layout;
import android.text.PackedIntVector;
import android.text.PackedObjectVector;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.UpdateLayout;
import android.text.style.WrapTogetherSpan;
import java.lang.ref.WeakReference;

public class DynamicLayout
extends Layout {
    private static final int PRIORITY = 128;
    private CharSequence mBase;
    private CharSequence mDisplay;
    private ChangeWatcher mWatcher;
    private boolean mIncludePad;
    private boolean mEllipsize;
    private int mEllipsizedWidth;
    private TextUtils.TruncateAt mEllipsizeAt;
    private PackedIntVector mInts;
    private PackedObjectVector<Layout.Directions> mObjects;
    private int mTopPadding;
    private int mBottomPadding;
    private static StaticLayout sStaticLayout = new StaticLayout(null);
    private static final Object[] sLock = new Object[0];
    private static final int START = 0;
    private static final int DIR = 0;
    private static final int TAB = 0;
    private static final int TOP = 1;
    private static final int DESCENT = 2;
    private static final int COLUMNS_NORMAL = 3;
    private static final int ELLIPSIS_START = 3;
    private static final int ELLIPSIS_COUNT = 4;
    private static final int COLUMNS_ELLIPSIZE = 5;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int DIR_SHIFT = 30;
    private static final int TAB_MASK = 0x20000000;
    private static final int ELLIPSIS_UNDEFINED = Integer.MIN_VALUE;

    public DynamicLayout(CharSequence base, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(base, base, paint, width, align, spacingmult, spacingadd, includepad);
    }

    public DynamicLayout(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(base, display, paint, width, align, spacingmult, spacingadd, includepad, null, 0);
    }

    public DynamicLayout(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        this(base, display, paint, width, align, TextDirectionHeuristics.FIRSTSTRONG_LTR, spacingmult, spacingadd, includepad, ellipsize, ellipsizedWidth);
    }

    public DynamicLayout(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        super(ellipsize == null ? display : (display instanceof Spanned ? new Layout.SpannedEllipsizer(display) : new Layout.Ellipsizer(display)), paint, width, align, textDir, spacingmult, spacingadd);
        int[] start;
        this.mBase = base;
        this.mDisplay = display;
        if (ellipsize != null) {
            this.mInts = new PackedIntVector(5);
            this.mEllipsizedWidth = ellipsizedWidth;
            this.mEllipsizeAt = ellipsize;
        } else {
            this.mInts = new PackedIntVector(3);
            this.mEllipsizedWidth = width;
            this.mEllipsizeAt = null;
        }
        this.mObjects = new PackedObjectVector(1);
        this.mIncludePad = includepad;
        if (ellipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = ellipsizedWidth;
            e.mMethod = ellipsize;
            this.mEllipsize = true;
        }
        if (ellipsize != null) {
            start = new int[5];
            start[3] = Integer.MIN_VALUE;
        } else {
            start = new int[3];
        }
        Layout.Directions[] dirs = new Layout.Directions[]{DIRS_ALL_LEFT_TO_RIGHT};
        Paint.FontMetricsInt fm = paint.getFontMetricsInt();
        int asc = fm.ascent;
        int desc = fm.descent;
        start[0] = 0x40000000;
        start[1] = 0;
        start[2] = desc;
        this.mInts.insertAt(0, start);
        start[1] = desc - asc;
        this.mInts.insertAt(1, start);
        this.mObjects.insertAt(0, (Layout.Directions[])dirs);
        this.reflow(base, 0, 0, base.length());
        if (base instanceof Spannable) {
            if (this.mWatcher == null) {
                this.mWatcher = new ChangeWatcher(this);
            }
            Spannable sp = (Spannable)base;
            ChangeWatcher[] spans = sp.getSpans(0, sp.length(), ChangeWatcher.class);
            for (int i = 0; i < spans.length; ++i) {
                sp.removeSpan(spans[i]);
            }
            sp.setSpan(this.mWatcher, 0, base.length(), 8388626);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reflow(CharSequence s, int where, int before, int after) {
        if (s != this.mBase) {
            return;
        }
        CharSequence text = this.mDisplay;
        int len = text.length();
        int find = TextUtils.lastIndexOf(text, '\n', where - 1);
        find = find < 0 ? 0 : ++find;
        int diff = where - find;
        before += diff;
        int look = TextUtils.indexOf(text, '\n', (where -= diff) + (after += diff));
        look = look < 0 ? len : ++look;
        int change = look - (where + after);
        before += change;
        after += change;
        if (text instanceof Spanned) {
            boolean again;
            Spanned sp = (Spanned)text;
            do {
                again = false;
                WrapTogetherSpan[] force = sp.getSpans(where, where + after, WrapTogetherSpan.class);
                for (int i = 0; i < force.length; ++i) {
                    int diff2;
                    int st = sp.getSpanStart(force[i]);
                    int en = sp.getSpanEnd(force[i]);
                    if (st < where) {
                        again = true;
                        diff2 = where - st;
                        before += diff2;
                        after += diff2;
                        where -= diff2;
                    }
                    if (en <= where + after) continue;
                    again = true;
                    diff2 = en - (where + after);
                    before += diff2;
                    after += diff2;
                }
            } while (again);
        }
        int startline = this.getLineForOffset(where);
        int startv = this.getLineTop(startline);
        int endline = this.getLineForOffset(where + before);
        if (where + after == len) {
            endline = this.getLineCount();
        }
        int endv = this.getLineTop(endline);
        boolean islast = endline == this.getLineCount();
        Object[] diff3 = sLock;
        synchronized (sLock) {
            int[] ints;
            StaticLayout reflowed = sStaticLayout;
            sStaticLayout = null;
            // ** MonitorExit[diff] (shouldn't be in output)
            if (reflowed == null) {
                reflowed = new StaticLayout(null);
            } else {
                reflowed.prepare();
            }
            reflowed.generate(text, where, where + after, this.getPaint(), this.getWidth(), this.getTextDirectionHeuristic(), this.getSpacingMultiplier(), this.getSpacingAdd(), false, true, this.mEllipsizedWidth, this.mEllipsizeAt);
            int n = reflowed.getLineCount();
            if (where + after != len && reflowed.getLineStart(n - 1) == where + after) {
                --n;
            }
            this.mInts.deleteAt(startline, endline - startline);
            this.mObjects.deleteAt(startline, endline - startline);
            int ht = reflowed.getLineTop(n);
            int toppad = 0;
            int botpad = 0;
            if (this.mIncludePad && startline == 0) {
                this.mTopPadding = toppad = reflowed.getTopPadding();
                ht -= toppad;
            }
            if (this.mIncludePad && islast) {
                this.mBottomPadding = botpad = reflowed.getBottomPadding();
                ht += botpad;
            }
            this.mInts.adjustValuesBelow(startline, 0, after - before);
            this.mInts.adjustValuesBelow(startline, 1, startv - endv + ht);
            if (this.mEllipsize) {
                ints = new int[5];
                ints[3] = Integer.MIN_VALUE;
            } else {
                ints = new int[3];
            }
            Layout.Directions[] objects = new Layout.Directions[1];
            for (int i = 0; i < n; ++i) {
                ints[0] = reflowed.getLineStart(i) | reflowed.getParagraphDirection(i) << 30 | (reflowed.getLineContainsTab(i) ? 0x20000000 : 0);
                int top = reflowed.getLineTop(i) + startv;
                if (i > 0) {
                    top -= toppad;
                }
                ints[1] = top;
                int desc = reflowed.getLineDescent(i);
                if (i == n - 1) {
                    desc += botpad;
                }
                ints[2] = desc;
                objects[0] = reflowed.getLineDirections(i);
                if (this.mEllipsize) {
                    ints[3] = reflowed.getEllipsisStart(i);
                    ints[4] = reflowed.getEllipsisCount(i);
                }
                this.mInts.insertAt(startline + i, ints);
                this.mObjects.insertAt(startline + i, (Layout.Directions[])objects);
            }
            Object[] objectArray = sLock;
            synchronized (sLock) {
                sStaticLayout = reflowed;
                reflowed.finish();
                // ** MonitorExit[var22_29] (shouldn't be in output)
                return;
            }
        }
    }

    public int getLineCount() {
        return this.mInts.size() - 1;
    }

    public int getLineTop(int line) {
        return this.mInts.getValue(line, 1);
    }

    public int getLineDescent(int line) {
        return this.mInts.getValue(line, 2);
    }

    public int getLineStart(int line) {
        return this.mInts.getValue(line, 0) & 0x1FFFFFFF;
    }

    public boolean getLineContainsTab(int line) {
        return (this.mInts.getValue(line, 0) & 0x20000000) != 0;
    }

    public int getParagraphDirection(int line) {
        return this.mInts.getValue(line, 0) >> 30;
    }

    public Layout.Directions getLineDirections(int line) {
        return this.mObjects.getValue(line, 0);
    }

    public int getTopPadding() {
        return this.mTopPadding;
    }

    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    public int getEllipsisStart(int line) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(line, 3);
    }

    public int getEllipsisCount(int line) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(line, 4);
    }

    private static class ChangeWatcher
    implements TextWatcher,
    SpanWatcher {
        private WeakReference<DynamicLayout> mLayout;

        public ChangeWatcher(DynamicLayout layout2) {
            this.mLayout = new WeakReference<DynamicLayout>(layout2);
        }

        private void reflow(CharSequence s, int where, int before, int after) {
            DynamicLayout ml = (DynamicLayout)this.mLayout.get();
            if (ml != null) {
                ml.reflow(s, where, before, after);
            } else if (s instanceof Spannable) {
                ((Spannable)s).removeSpan(this);
            }
        }

        public void beforeTextChanged(CharSequence s, int where, int before, int after) {
        }

        public void onTextChanged(CharSequence s, int where, int before, int after) {
            this.reflow(s, where, before, after);
        }

        public void afterTextChanged(Editable s) {
        }

        public void onSpanAdded(Spannable s, Object o, int start, int end) {
            if (o instanceof UpdateLayout) {
                this.reflow(s, start, end - start, end - start);
            }
        }

        public void onSpanRemoved(Spannable s, Object o, int start, int end) {
            if (o instanceof UpdateLayout) {
                this.reflow(s, start, end - start, end - start);
            }
        }

        public void onSpanChanged(Spannable s, Object o, int start, int end, int nstart, int nend) {
            if (o instanceof UpdateLayout) {
                this.reflow(s, start, end - start, end - start);
                this.reflow(s, nstart, nend - nstart, nend - nstart);
            }
        }
    }
}

