/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.view.MotionEvent;
import com.android.tools.layoutlib.create.OverrideMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityTracker
implements Poolable<VelocityTracker> {
    private static final Pool<VelocityTracker> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<VelocityTracker>(){

        @Override
        public VelocityTracker newInstance() {
            return new VelocityTracker();
        }

        @Override
        public void onAcquired(VelocityTracker element) {
        }

        @Override
        public void onReleased(VelocityTracker element) {
            element.clear();
        }
    }, 2));
    private static final int ACTIVE_POINTER_ID = -1;
    private int mPtr = VelocityTracker.nativeInitialize();
    private VelocityTracker mNext;
    private boolean mIsPooled;

    private static int nativeInitialize() {
        return OverrideMethod.invokeI("android.view.VelocityTracker#nativeInitialize()I", true, null);
    }

    private static void nativeDispose(int n) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeDispose(I)V", true, null);
    }

    private static void nativeClear(int n) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeClear(I)V", true, null);
    }

    private static void nativeAddMovement(int n, MotionEvent motionEvent) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeAddMovement(ILandroid/view/MotionEvent;)V", true, null);
    }

    private static void nativeComputeCurrentVelocity(int n, int n2, float f) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeComputeCurrentVelocity(IIF)V", true, null);
    }

    private static float nativeGetXVelocity(int n, int n2) {
        return OverrideMethod.invokeF("android.view.VelocityTracker#nativeGetXVelocity(II)F", true, null);
    }

    private static float nativeGetYVelocity(int n, int n2) {
        return OverrideMethod.invokeF("android.view.VelocityTracker#nativeGetYVelocity(II)F", true, null);
    }

    private static boolean nativeGetEstimator(int n, int n2, int n3, int n4, Estimator estimator) {
        return OverrideMethod.invokeI("android.view.VelocityTracker#nativeGetEstimator(IIIILandroid/view/VelocityTracker$Estimator;)Z", true, null) != 0;
    }

    public static VelocityTracker obtain() {
        return sPool.acquire();
    }

    public void recycle() {
        sPool.release(this);
    }

    @Override
    public void setNextPoolable(VelocityTracker element) {
        this.mNext = element;
    }

    @Override
    public VelocityTracker getNextPoolable() {
        return this.mNext;
    }

    @Override
    public boolean isPooled() {
        return this.mIsPooled;
    }

    @Override
    public void setPooled(boolean isPooled) {
        this.mIsPooled = isPooled;
    }

    private VelocityTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mPtr != 0) {
                VelocityTracker.nativeDispose(this.mPtr);
                this.mPtr = 0;
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        VelocityTracker.nativeClear(this.mPtr);
    }

    public void addMovement(MotionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        VelocityTracker.nativeAddMovement(this.mPtr, event);
    }

    public void computeCurrentVelocity(int units) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, maxVelocity);
    }

    public float getXVelocity() {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, -1);
    }

    public float getYVelocity() {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, -1);
    }

    public float getXVelocity(int id2) {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, id2);
    }

    public float getYVelocity(int id2) {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, id2);
    }

    public boolean getEstimator(int id2, int degree, int horizonMillis, Estimator outEstimator) {
        if (outEstimator == null) {
            throw new IllegalArgumentException("outEstimator must not be null");
        }
        return VelocityTracker.nativeGetEstimator(this.mPtr, id2, degree, horizonMillis, outEstimator);
    }

    public static class Estimator {
        private static final int MAX_DEGREE = 2;
        public final float[] xCoeff = new float[3];
        public final float[] yCoeff = new float[3];
        public int degree;
        public float confidence;

        public float estimateX(float time) {
            return this.estimate(time, this.xCoeff);
        }

        public float estimateY(float time) {
            return this.estimate(time, this.yCoeff);
        }

        private float estimate(float time, float[] c) {
            float a = 0.0f;
            float scale = 1.0f;
            for (int i = 0; i <= this.degree; ++i) {
                a += c[i] * scale;
                scale *= time;
            }
            return a;
        }
    }
}

