/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class CycleInterpolator
implements Interpolator {
    private float mCycles;

    public CycleInterpolator(float cycles) {
        this.mCycles = cycles;
    }

    public CycleInterpolator(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CycleInterpolator);
        this.mCycles = a.getFloat(0, 1.0f);
        a.recycle();
    }

    public float getInterpolation(float input) {
        return (float)Math.sin((double)(2.0f * this.mCycles) * Math.PI * (double)input);
    }
}

