/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.Headers;
import android.webkit.LoadListener;
import android.webkit.StreamLoader;
import java.io.InputStream;

public class WebResourceResponse {
    private String mMimeType;
    private String mEncoding;
    private InputStream mInputStream;

    public WebResourceResponse(String mimeType, String encoding, InputStream data) {
        this.mMimeType = mimeType;
        this.mEncoding = encoding;
        this.mInputStream = data;
    }

    public void setMimeType(String mimeType) {
        this.mMimeType = mimeType;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public void setEncoding(String encoding) {
        this.mEncoding = encoding;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setData(InputStream data) {
        this.mInputStream = data;
    }

    public InputStream getData() {
        return this.mInputStream;
    }

    StreamLoader loader(LoadListener listener) {
        return new Loader(listener);
    }

    private class Loader
    extends StreamLoader {
        Loader(LoadListener loadListener) {
            super(loadListener);
            this.mDataStream = WebResourceResponse.this.mInputStream;
        }

        protected boolean setupStreamAndSendStatus() {
            this.mLoadListener.status(1, 1, this.mDataStream != null ? 200 : 404, "");
            return true;
        }

        protected void buildHeaders(Headers headers) {
            headers.setContentType(WebResourceResponse.this.mMimeType);
            headers.setContentEncoding(WebResourceResponse.this.mEncoding);
        }
    }
}

