/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.Headers;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.webkit.ByteArrayBuilder;
import android.webkit.CacheManager;
import android.webkit.FrameLoader;
import android.webkit.JniUtil;
import android.webkit.LoadListener;
import android.webkit.StreamLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class WebViewWorker
extends Handler {
    private static final String THREAD_NAME = "WebViewWorkerThread";
    private static WebViewWorker sWorkerHandler;
    private static Map<LoadListener, CacheManager.CacheResult> mCacheResultMap;
    private static final int CACHE_TRANSACTION_TICKER_INTERVAL = 60000;
    private static boolean mCacheTickersBlocked;
    static final int MSG_ADD_STREAMLOADER = 101;
    static final int MSG_ADD_HTTPLOADER = 102;
    static final int MSG_CREATE_CACHE = 103;
    static final int MSG_UPDATE_CACHE_ENCODING = 104;
    static final int MSG_APPEND_CACHE = 105;
    static final int MSG_SAVE_CACHE = 106;
    static final int MSG_REMOVE_CACHE = 107;
    static final int MSG_TRIM_CACHE = 108;
    static final int MSG_CLEAR_CACHE = 109;
    static final int MSG_CACHE_TRANSACTION_TICKER = 110;
    static final int MSG_PAUSE_CACHE_TRANSACTION = 111;
    static final int MSG_RESUME_CACHE_TRANSACTION = 112;

    static synchronized WebViewWorker getHandler() {
        if (sWorkerHandler == null) {
            HandlerThread thread = new HandlerThread(THREAD_NAME, 1);
            thread.start();
            sWorkerHandler = new WebViewWorker(thread.getLooper());
        }
        return sWorkerHandler;
    }

    private WebViewWorker(Looper looper) {
        super(looper);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 101: {
                StreamLoader loader = (StreamLoader)msg.obj;
                loader.load();
                break;
            }
            case 102: {
                FrameLoader loader = (FrameLoader)msg.obj;
                loader.handleHTTPLoad();
                break;
            }
            case 103: {
                assert (!JniUtil.useChromiumHttpStack());
                CacheCreateData data = (CacheCreateData)msg.obj;
                CacheManager.CacheResult cache = CacheManager.createCacheFile(data.mUrl, data.mStatusCode, data.mHeaders, data.mMimeType, data.mPostId, false);
                if (cache != null) {
                    mCacheResultMap.put(data.mListener, cache);
                    break;
                }
                mCacheResultMap.remove(data.mListener);
                break;
            }
            case 104: {
                assert (!JniUtil.useChromiumHttpStack());
                CacheEncoding data = (CacheEncoding)msg.obj;
                CacheManager.CacheResult cache = mCacheResultMap.get(data.mListener);
                if (cache == null) break;
                cache.encoding = data.mEncoding;
                break;
            }
            case 105: {
                assert (!JniUtil.useChromiumHttpStack());
                CacheData data = (CacheData)msg.obj;
                CacheManager.CacheResult cache = mCacheResultMap.get(data.mListener);
                if (cache != null) {
                    cache.contentLength += (long)data.mChunk.mLength;
                    if (cache.contentLength > CacheManager.CACHE_MAX_SIZE) {
                        CacheManager.cleanupCacheFile(cache);
                        mCacheResultMap.remove(data.mListener);
                    } else {
                        try {
                            cache.outStream.write(data.mChunk.mArray, 0, data.mChunk.mLength);
                        }
                        catch (IOException e) {
                            CacheManager.cleanupCacheFile(cache);
                            mCacheResultMap.remove(data.mListener);
                        }
                    }
                }
                data.mChunk.release();
                break;
            }
            case 106: {
                assert (!JniUtil.useChromiumHttpStack());
                CacheSaveData data = (CacheSaveData)msg.obj;
                CacheManager.CacheResult cache = mCacheResultMap.get(data.mListener);
                if (cache == null) break;
                CacheManager.saveCacheFile(data.mUrl, data.mPostId, cache);
                mCacheResultMap.remove(data.mListener);
                break;
            }
            case 107: {
                assert (!JniUtil.useChromiumHttpStack());
                LoadListener listener = (LoadListener)msg.obj;
                CacheManager.CacheResult cache = mCacheResultMap.get(listener);
                if (cache == null) break;
                CacheManager.cleanupCacheFile(cache);
                mCacheResultMap.remove(listener);
                break;
            }
            case 108: {
                assert (!JniUtil.useChromiumHttpStack());
                CacheManager.trimCacheIfNeeded();
                break;
            }
            case 109: {
                assert (!JniUtil.useChromiumHttpStack());
                CacheManager.clearCache();
                break;
            }
            case 110: {
                assert (!JniUtil.useChromiumHttpStack());
                if (mCacheTickersBlocked) break;
                CacheManager.endTransaction();
                CacheManager.startTransaction();
                this.sendEmptyMessageDelayed(110, 60000L);
                break;
            }
            case 111: {
                assert (!JniUtil.useChromiumHttpStack());
                if (!CacheManager.disableTransaction()) break;
                mCacheTickersBlocked = true;
                this.removeMessages(110);
                break;
            }
            case 112: {
                assert (!JniUtil.useChromiumHttpStack());
                if (!CacheManager.enableTransaction()) break;
                mCacheTickersBlocked = false;
                this.sendEmptyMessageDelayed(110, 60000L);
            }
        }
    }

    static {
        mCacheResultMap = new HashMap<LoadListener, CacheManager.CacheResult>();
        mCacheTickersBlocked = true;
    }

    static class CacheData {
        LoadListener mListener;
        ByteArrayBuilder.Chunk mChunk;

        CacheData() {
        }
    }

    static class CacheEncoding {
        LoadListener mListener;
        String mEncoding;

        CacheEncoding() {
        }
    }

    static class CacheSaveData {
        LoadListener mListener;
        String mUrl;
        long mPostId;

        CacheSaveData() {
        }
    }

    static class CacheCreateData {
        LoadListener mListener;
        String mUrl;
        String mMimeType;
        int mStatusCode;
        long mPostId;
        Headers mHeaders;

        CacheCreateData() {
        }
    }
}

