/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageButton;

public class ZoomButton
extends ImageButton
implements View.OnLongClickListener {
    private final Handler mHandler;
    private final Runnable mRunnable = new Runnable(){

        public void run() {
            if (ZoomButton.this.hasOnClickListeners() && ZoomButton.this.mIsInLongpress && ZoomButton.this.isEnabled()) {
                ZoomButton.this.callOnClick();
                ZoomButton.this.mHandler.postDelayed(this, ZoomButton.this.mZoomSpeed);
            }
        }
    };
    private long mZoomSpeed = 1000L;
    private boolean mIsInLongpress;

    public ZoomButton(Context context) {
        this(context, null);
    }

    public ZoomButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ZoomButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mHandler = new Handler();
        this.setOnLongClickListener(this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 3 || event.getAction() == 1) {
            this.mIsInLongpress = false;
        }
        return super.onTouchEvent(event);
    }

    public void setZoomSpeed(long speed) {
        this.mZoomSpeed = speed;
    }

    public boolean onLongClick(View v) {
        this.mIsInLongpress = true;
        this.mHandler.post(this.mRunnable);
        return true;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        this.mIsInLongpress = false;
        return super.onKeyUp(keyCode, event);
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.setPressed(false);
        }
        super.setEnabled(enabled);
    }

    public boolean dispatchUnhandledMove(View focused, int direction) {
        this.clearFocus();
        return super.dispatchUnhandledMove(focused, direction);
    }
}

