/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;

public class DefaultPhoneNotifier
implements PhoneNotifier {
    static final String LOG_TAG = "GSM";
    private static final boolean DBG = true;
    private ITelephonyRegistry mRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));

    DefaultPhoneNotifier() {
    }

    public void notifyPhoneState(Phone sender) {
        Call ringingCall = sender.getRingingCall();
        String incomingNumber = "";
        if (ringingCall != null && ringingCall.getEarliestConnection() != null) {
            incomingNumber = ringingCall.getEarliestConnection().getAddress();
        }
        try {
            this.mRegistry.notifyCallState(DefaultPhoneNotifier.convertCallState(sender.getState()), incomingNumber);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void notifyServiceState(Phone sender) {
        ServiceState ss = sender.getServiceState();
        if (ss == null) {
            ss = new ServiceState();
            ss.setStateOutOfService();
        }
        try {
            this.mRegistry.notifyServiceState(ss);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifySignalStrength(Phone sender) {
        try {
            this.mRegistry.notifySignalStrength(sender.getSignalStrength());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyMessageWaitingChanged(Phone sender) {
        try {
            this.mRegistry.notifyMessageWaitingChanged(sender.getMessageWaitingIndicator());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyCallForwardingChanged(Phone sender) {
        try {
            this.mRegistry.notifyCallForwardingChanged(sender.getCallForwardingIndicator());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyDataActivity(Phone sender) {
        try {
            this.mRegistry.notifyDataActivity(DefaultPhoneNotifier.convertDataActivityState(sender.getDataActivityState()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyDataConnection(Phone sender, String reason, String apnType, Phone.DataState state) {
        this.doNotifyDataConnection(sender, reason, apnType, state);
    }

    private void doNotifyDataConnection(Phone sender, String reason, String apnType, Phone.DataState state) {
        ServiceState ss;
        TelephonyManager telephony = TelephonyManager.getDefault();
        LinkProperties linkProperties = null;
        LinkCapabilities linkCapabilities = null;
        boolean roaming = false;
        if (state == Phone.DataState.CONNECTED) {
            linkProperties = sender.getLinkProperties(apnType);
            linkCapabilities = sender.getLinkCapabilities(apnType);
        }
        if ((ss = sender.getServiceState()) != null) {
            roaming = ss.getRoaming();
        }
        try {
            this.mRegistry.notifyDataConnection(DefaultPhoneNotifier.convertDataState(state), sender.isDataConnectivityPossible(apnType), reason, sender.getActiveApnHost(apnType), apnType, linkProperties, linkCapabilities, telephony != null ? telephony.getNetworkType() : 0, roaming);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void notifyDataConnectionFailed(Phone sender, String reason, String apnType) {
        try {
            this.mRegistry.notifyDataConnectionFailed(reason, apnType);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void notifyCellLocation(Phone sender) {
        Bundle data = new Bundle();
        sender.getCellLocation().fillInNotifierBundle(data);
        try {
            this.mRegistry.notifyCellLocation(data);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void notifyOtaspChanged(Phone sender, int otaspMode) {
        try {
            this.mRegistry.notifyOtaspChanged(otaspMode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void log(String s) {
        Log.d(LOG_TAG, "[PhoneNotifier] " + s);
    }

    public static int convertCallState(Phone.State state) {
        switch (state) {
            case RINGING: {
                return 1;
            }
            case OFFHOOK: {
                return 2;
            }
        }
        return 0;
    }

    public static Phone.State convertCallState(int state) {
        switch (state) {
            case 1: {
                return Phone.State.RINGING;
            }
            case 2: {
                return Phone.State.OFFHOOK;
            }
        }
        return Phone.State.IDLE;
    }

    public static int convertDataState(Phone.DataState state) {
        switch (state) {
            case CONNECTING: {
                return 1;
            }
            case CONNECTED: {
                return 2;
            }
            case SUSPENDED: {
                return 3;
            }
        }
        return 0;
    }

    public static Phone.DataState convertDataState(int state) {
        switch (state) {
            case 1: {
                return Phone.DataState.CONNECTING;
            }
            case 2: {
                return Phone.DataState.CONNECTED;
            }
            case 3: {
                return Phone.DataState.SUSPENDED;
            }
        }
        return Phone.DataState.DISCONNECTED;
    }

    public static int convertDataActivityState(Phone.DataActivityState state) {
        switch (state) {
            case DATAIN: {
                return 1;
            }
            case DATAOUT: {
                return 2;
            }
            case DATAINANDOUT: {
                return 3;
            }
            case DORMANT: {
                return 4;
            }
        }
        return 0;
    }

    public static Phone.DataActivityState convertDataActivityState(int state) {
        switch (state) {
            case 1: {
                return Phone.DataActivityState.DATAIN;
            }
            case 2: {
                return Phone.DataActivityState.DATAOUT;
            }
            case 3: {
                return Phone.DataActivityState.DATAINANDOUT;
            }
            case 4: {
                return Phone.DataActivityState.DORMANT;
            }
        }
        return Phone.DataActivityState.NONE;
    }
}

