/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.PhoneBase;

public class SmsStorageMonitor
extends Handler {
    private static final String TAG = "SmsStorageMonitor";
    private static final int EVENT_ICC_FULL = 1;
    private static final int EVENT_REPORT_MEMORY_STATUS_DONE = 2;
    private static final int EVENT_RADIO_ON = 3;
    private final Context mContext;
    private PowerManager.WakeLock mWakeLock;
    private boolean mReportMemoryStatusPending;
    final CommandsInterface mCm;
    boolean mStorageAvailable = true;
    private static final int WAKE_LOCK_TIMEOUT = 5000;
    private final BroadcastReceiver mResultReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_FULL")) {
                SmsStorageMonitor.this.mStorageAvailable = false;
                SmsStorageMonitor.this.mCm.reportSmsMemoryStatus(false, SmsStorageMonitor.this.obtainMessage(2));
            } else if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_NOT_FULL")) {
                SmsStorageMonitor.this.mStorageAvailable = true;
                SmsStorageMonitor.this.mCm.reportSmsMemoryStatus(true, SmsStorageMonitor.this.obtainMessage(2));
            }
        }
    };

    public SmsStorageMonitor(PhoneBase phone) {
        this.mContext = phone.getContext();
        this.mCm = phone.mCM;
        this.createWakelock();
        this.mCm.setOnIccSmsFull(this, 1, null);
        this.mCm.registerForOn(this, 3, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.DEVICE_STORAGE_FULL");
        filter.addAction("android.intent.action.DEVICE_STORAGE_NOT_FULL");
        this.mContext.registerReceiver(this.mResultReceiver, filter);
    }

    public void dispose() {
        this.mCm.unSetOnIccSmsFull(this);
        this.mCm.unregisterForOn(this);
        this.mContext.unregisterReceiver(this.mResultReceiver);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleIccFull();
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    this.mReportMemoryStatusPending = true;
                    Log.v(TAG, "Memory status report to modem pending : mStorageAvailable = " + this.mStorageAvailable);
                    break;
                }
                this.mReportMemoryStatusPending = false;
                break;
            }
            case 3: {
                if (!this.mReportMemoryStatusPending) break;
                Log.v(TAG, "Sending pending memory status report : mStorageAvailable = " + this.mStorageAvailable);
                this.mCm.reportSmsMemoryStatus(this.mStorageAvailable, this.obtainMessage(2));
            }
        }
    }

    private void createWakelock() {
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, TAG);
        this.mWakeLock.setReferenceCounted(true);
    }

    private void handleIccFull() {
        Intent intent = new Intent("android.provider.Telephony.SIM_FULL");
        this.mWakeLock.acquire(5000L);
        this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public boolean isStorageAvailable() {
        return this.mStorageAvailable;
    }
}

