/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import com.android.internal.telephony.cat.ComprehensionTlv;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BerTlv {
    private int mTag = 0;
    private List<ComprehensionTlv> mCompTlvs = null;
    public static final int BER_UNKNOWN_TAG = 0;
    public static final int BER_PROACTIVE_COMMAND_TAG = 208;
    public static final int BER_MENU_SELECTION_TAG = 211;
    public static final int BER_EVENT_DOWNLOAD_TAG = 214;

    private BerTlv(int tag, List<ComprehensionTlv> ctlvs) {
        this.mTag = tag;
        this.mCompTlvs = ctlvs;
    }

    public List<ComprehensionTlv> getComprehensionTlvs() {
        return this.mCompTlvs;
    }

    public int getTag() {
        return this.mTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BerTlv decode(byte[] data) throws ResultException {
        int tag;
        int curIndex = 0;
        int endIndex = data.length;
        int length = 0;
        try {
            tag = data[curIndex++] & 0xFF;
            if (tag == 208) {
                int temp;
                if ((temp = data[curIndex++] & 0xFF) < 128) {
                    length = temp;
                } else {
                    if (temp != 129) throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
                    if ((temp = data[curIndex++] & 0xFF) < 128) {
                        throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
                    }
                    length = temp;
                }
            } else if (ComprehensionTlvTag.COMMAND_DETAILS.value() == (tag & 0xFFFFFF7F)) {
                tag = 0;
                curIndex = 0;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
        catch (ResultException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        if (endIndex - curIndex < length) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        List<ComprehensionTlv> ctlvs = ComprehensionTlv.decodeMany(data, curIndex);
        return new BerTlv(tag, ctlvs);
    }
}

