/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IStatusBar;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;

public class StatusBarManager {
    public static final int DISABLE_EXPAND = 1;
    public static final int DISABLE_NOTIFICATION_ICONS = 2;
    public static final int DISABLE_NOTIFICATION_ALERTS = 4;
    public static final int DISABLE_NONE = 0;
    public Context mContext;
    public IStatusBar mService;
    public IBinder mToken = new Binder();

    public StatusBarManager(Context context) {
        this.mContext = context;
        this.mService = IStatusBar.Stub.asInterface(ServiceManager.getService("statusbar"));
    }

    public void disable(int what) {
        try {
            this.mService.disable(what, this.mToken, this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void expand() {
        try {
            this.mService.activate();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void collapse() {
        try {
            this.mService.deactivate();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void toggle() {
        try {
            this.mService.toggle();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public IBinder addIcon(String slot, int iconId, int iconLevel) {
        try {
            return this.mService.addIcon(slot, this.mContext.getPackageName(), iconId, iconLevel);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void updateIcon(IBinder key, String slot, int iconId, int iconLevel) {
        try {
            this.mService.updateIcon(key, slot, this.mContext.getPackageName(), iconId, iconLevel);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void removeIcon(IBinder key) {
        try {
            this.mService.removeIcon(key);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }
}

