/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.Entity;
import android.content.EntityIterator;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.RemoteException;

public abstract class AbstractCursorEntityIterator
implements EntityIterator {
    public final Cursor mEntityCursor;
    public final SQLiteDatabase mDb;
    public volatile Entity mNextEntity;
    public volatile boolean mIsClosed;

    public AbstractCursorEntityIterator(SQLiteDatabase db, Cursor entityCursor) {
        this.mEntityCursor = entityCursor;
        this.mDb = db;
        this.mNextEntity = null;
        this.mIsClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillEntityIfAvailable() {
        while (this.mNextEntity == null) {
            if (!this.mEntityCursor.moveToNext()) {
                return;
            }
            this.mNextEntity = this.newEntityFromCursorLocked(this.mEntityCursor);
        }
        this.mDb.beginTransaction();
        try {
            int position = this.mEntityCursor.getPosition();
            this.mNextEntity = this.newEntityFromCursorLocked(this.mEntityCursor);
            int newPosition = this.mEntityCursor.getPosition();
            if (newPosition != position) {
                throw new IllegalStateException("the cursor position changed during the call tonewEntityFromCursorLocked, from " + position + " to " + newPosition);
            }
            Object var4_3 = null;
            this.mDb.endTransaction();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mDb.endTransaction();
            throw throwable;
        }
    }

    public boolean hasNext() {
        if (this.mIsClosed) {
            throw new IllegalStateException("calling hasNext() when the iterator is closed");
        }
        this.fillEntityIfAvailable();
        return this.mNextEntity != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity next() {
        if (this.mIsClosed) {
            throw new IllegalStateException("calling next() when the iterator is closed");
        }
        if (!this.hasNext()) {
            throw new IllegalStateException("you may only call next() if hasNext() is true");
        }
        try {
            Entity entity = this.mNextEntity;
            Object var3_2 = null;
            this.mNextEntity = null;
            return entity;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mNextEntity = null;
            throw throwable;
        }
    }

    public void reset() throws RemoteException {
        if (this.mIsClosed) {
            throw new IllegalStateException("calling reset() when the iterator is closed");
        }
        this.mEntityCursor.moveToPosition(-1);
        this.mNextEntity = null;
    }

    public void close() {
        if (this.mIsClosed) {
            throw new IllegalStateException("closing when already closed");
        }
        this.mIsClosed = true;
        this.mEntityCursor.close();
    }

    public abstract Entity newEntityFromCursorLocked(Cursor var1);
}

