/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Parcelable,
Comparable<Configuration> {
    public float fontScale;
    public int mcc;
    public int mnc;
    public Locale locale;
    public boolean userSetLocale;
    public static final int SCREENLAYOUT_SIZE_MASK = 15;
    public static final int SCREENLAYOUT_SIZE_UNDEFINED = 0;
    public static final int SCREENLAYOUT_SIZE_SMALL = 1;
    public static final int SCREENLAYOUT_SIZE_NORMAL = 2;
    public static final int SCREENLAYOUT_SIZE_LARGE = 3;
    public static final int SCREENLAYOUT_LONG_MASK = 48;
    public static final int SCREENLAYOUT_LONG_UNDEFINED = 0;
    public static final int SCREENLAYOUT_LONG_NO = 16;
    public static final int SCREENLAYOUT_LONG_YES = 32;
    public static final int SCREENLAYOUT_COMPAT_NEEDED = 0x10000000;
    public int screenLayout;
    public static final int TOUCHSCREEN_UNDEFINED = 0;
    public static final int TOUCHSCREEN_NOTOUCH = 1;
    public static final int TOUCHSCREEN_STYLUS = 2;
    public static final int TOUCHSCREEN_FINGER = 3;
    public int touchscreen;
    public static final int KEYBOARD_UNDEFINED = 0;
    public static final int KEYBOARD_NOKEYS = 1;
    public static final int KEYBOARD_QWERTY = 2;
    public static final int KEYBOARD_12KEY = 3;
    public int keyboard;
    public static final int KEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int KEYBOARDHIDDEN_NO = 1;
    public static final int KEYBOARDHIDDEN_YES = 2;
    public static final int KEYBOARDHIDDEN_SOFT = 3;
    public int keyboardHidden;
    public static final int HARDKEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int HARDKEYBOARDHIDDEN_NO = 1;
    public static final int HARDKEYBOARDHIDDEN_YES = 2;
    public int hardKeyboardHidden;
    public static final int NAVIGATION_UNDEFINED = 0;
    public static final int NAVIGATION_NONAV = 1;
    public static final int NAVIGATION_DPAD = 2;
    public static final int NAVIGATION_TRACKBALL = 3;
    public static final int NAVIGATION_WHEEL = 4;
    public int navigation;
    public static final int NAVIGATIONHIDDEN_UNDEFINED = 0;
    public static final int NAVIGATIONHIDDEN_NO = 1;
    public static final int NAVIGATIONHIDDEN_YES = 2;
    public int navigationHidden;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_LANDSCAPE = 2;
    public static final int ORIENTATION_SQUARE = 3;
    public int orientation;
    public static final Parcelable.Creator<Configuration> CREATOR = new Parcelable.Creator<Configuration>(){

        @Override
        public Configuration createFromParcel(Parcel source) {
            return new Configuration(source, null);
        }

        public Configuration[] newArray(int size) {
            return new Configuration[size];
        }
    };

    public Configuration() {
        this.setToDefaults();
    }

    public Configuration(Configuration o) {
        this.fontScale = o.fontScale;
        this.mcc = o.mcc;
        this.mnc = o.mnc;
        if (o.locale != null) {
            this.locale = (Locale)o.locale.clone();
        }
        this.userSetLocale = o.userSetLocale;
        this.touchscreen = o.touchscreen;
        this.keyboard = o.keyboard;
        this.keyboardHidden = o.keyboardHidden;
        this.hardKeyboardHidden = o.hardKeyboardHidden;
        this.navigation = o.navigation;
        this.navigationHidden = o.navigationHidden;
        this.orientation = o.orientation;
        this.screenLayout = o.screenLayout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{ scale=");
        sb.append(this.fontScale);
        sb.append(" imsi=");
        sb.append(this.mcc);
        sb.append("/");
        sb.append(this.mnc);
        sb.append(" loc=");
        sb.append(this.locale);
        sb.append(" touch=");
        sb.append(this.touchscreen);
        sb.append(" keys=");
        sb.append(this.keyboard);
        sb.append("/");
        sb.append(this.keyboardHidden);
        sb.append("/");
        sb.append(this.hardKeyboardHidden);
        sb.append(" nav=");
        sb.append(this.navigation);
        sb.append("/");
        sb.append(this.navigationHidden);
        sb.append(" orien=");
        sb.append(this.orientation);
        sb.append(" layout=");
        sb.append(this.screenLayout);
        sb.append('}');
        return sb.toString();
    }

    public void setToDefaults() {
        this.fontScale = 1.0f;
        this.mnc = 0;
        this.mcc = 0;
        this.locale = Locale.getDefault();
        this.userSetLocale = false;
        this.touchscreen = 0;
        this.keyboard = 0;
        this.keyboardHidden = 0;
        this.hardKeyboardHidden = 0;
        this.navigation = 0;
        this.navigationHidden = 0;
        this.orientation = 0;
        this.screenLayout = 0;
    }

    @Deprecated
    public void makeDefault() {
        this.setToDefaults();
    }

    public int updateFrom(Configuration delta) {
        int changed = 0;
        if (delta.fontScale > 0.0f && this.fontScale != delta.fontScale) {
            changed |= 0x40000000;
            this.fontScale = delta.fontScale;
        }
        if (delta.mcc != 0 && this.mcc != delta.mcc) {
            changed |= 1;
            this.mcc = delta.mcc;
        }
        if (delta.mnc != 0 && this.mnc != delta.mnc) {
            changed |= 2;
            this.mnc = delta.mnc;
        }
        if (!(delta.locale == null || this.locale != null && this.locale.equals(delta.locale))) {
            changed |= 4;
            Locale locale = this.locale = delta.locale != null ? (Locale)delta.locale.clone() : null;
        }
        if (delta.userSetLocale && (!this.userSetLocale || (changed & 4) != 0)) {
            this.userSetLocale = true;
            changed |= 4;
        }
        if (delta.touchscreen != 0 && this.touchscreen != delta.touchscreen) {
            changed |= 8;
            this.touchscreen = delta.touchscreen;
        }
        if (delta.keyboard != 0 && this.keyboard != delta.keyboard) {
            changed |= 0x10;
            this.keyboard = delta.keyboard;
        }
        if (delta.keyboardHidden != 0 && this.keyboardHidden != delta.keyboardHidden) {
            changed |= 0x20;
            this.keyboardHidden = delta.keyboardHidden;
        }
        if (delta.hardKeyboardHidden != 0 && this.hardKeyboardHidden != delta.hardKeyboardHidden) {
            changed |= 0x20;
            this.hardKeyboardHidden = delta.hardKeyboardHidden;
        }
        if (delta.navigation != 0 && this.navigation != delta.navigation) {
            changed |= 0x40;
            this.navigation = delta.navigation;
        }
        if (delta.navigationHidden != 0 && this.navigationHidden != delta.navigationHidden) {
            changed |= 0x20;
            this.navigationHidden = delta.navigationHidden;
        }
        if (delta.orientation != 0 && this.orientation != delta.orientation) {
            changed |= 0x80;
            this.orientation = delta.orientation;
        }
        if (delta.screenLayout != 0 && this.screenLayout != delta.screenLayout) {
            changed |= 0x100;
            this.screenLayout = delta.screenLayout;
        }
        return changed;
    }

    public int diff(Configuration delta) {
        int changed = 0;
        if (delta.fontScale > 0.0f && this.fontScale != delta.fontScale) {
            changed |= 0x40000000;
        }
        if (delta.mcc != 0 && this.mcc != delta.mcc) {
            changed |= 1;
        }
        if (delta.mnc != 0 && this.mnc != delta.mnc) {
            changed |= 2;
        }
        if (!(delta.locale == null || this.locale != null && this.locale.equals(delta.locale))) {
            changed |= 4;
        }
        if (delta.touchscreen != 0 && this.touchscreen != delta.touchscreen) {
            changed |= 8;
        }
        if (delta.keyboard != 0 && this.keyboard != delta.keyboard) {
            changed |= 0x10;
        }
        if (delta.keyboardHidden != 0 && this.keyboardHidden != delta.keyboardHidden) {
            changed |= 0x20;
        }
        if (delta.hardKeyboardHidden != 0 && this.hardKeyboardHidden != delta.hardKeyboardHidden) {
            changed |= 0x20;
        }
        if (delta.navigation != 0 && this.navigation != delta.navigation) {
            changed |= 0x40;
        }
        if (delta.navigationHidden != 0 && this.navigationHidden != delta.navigationHidden) {
            changed |= 0x20;
        }
        if (delta.orientation != 0 && this.orientation != delta.orientation) {
            changed |= 0x80;
        }
        if (delta.screenLayout != 0 && this.screenLayout != delta.screenLayout) {
            changed |= 0x100;
        }
        return changed;
    }

    public static boolean needNewResources(int configChanges, int interestingChanges) {
        return (configChanges & (interestingChanges | 0x40000000)) != 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.fontScale);
        dest.writeInt(this.mcc);
        dest.writeInt(this.mnc);
        if (this.locale == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(this.locale.getLanguage());
            dest.writeString(this.locale.getCountry());
            dest.writeString(this.locale.getVariant());
        }
        if (this.userSetLocale) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.touchscreen);
        dest.writeInt(this.keyboard);
        dest.writeInt(this.keyboardHidden);
        dest.writeInt(this.hardKeyboardHidden);
        dest.writeInt(this.navigation);
        dest.writeInt(this.navigationHidden);
        dest.writeInt(this.orientation);
        dest.writeInt(this.screenLayout);
    }

    public Configuration(Parcel source) {
        this.fontScale = source.readFloat();
        this.mcc = source.readInt();
        this.mnc = source.readInt();
        if (source.readInt() != 0) {
            this.locale = new Locale(source.readString(), source.readString(), source.readString());
        }
        this.userSetLocale = source.readInt() == 1;
        this.touchscreen = source.readInt();
        this.keyboard = source.readInt();
        this.keyboardHidden = source.readInt();
        this.hardKeyboardHidden = source.readInt();
        this.navigation = source.readInt();
        this.navigationHidden = source.readInt();
        this.orientation = source.readInt();
        this.screenLayout = source.readInt();
    }

    @Override
    public int compareTo(Configuration that) {
        float a = this.fontScale;
        float b = that.fontScale;
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        int n = this.mcc - that.mcc;
        if (n != 0) {
            return n;
        }
        n = this.mnc - that.mnc;
        if (n != 0) {
            return n;
        }
        n = this.locale.getLanguage().compareTo(that.locale.getLanguage());
        if (n != 0) {
            return n;
        }
        n = this.locale.getCountry().compareTo(that.locale.getCountry());
        if (n != 0) {
            return n;
        }
        n = this.locale.getVariant().compareTo(that.locale.getVariant());
        if (n != 0) {
            return n;
        }
        n = this.touchscreen - that.touchscreen;
        if (n != 0) {
            return n;
        }
        n = this.keyboard - that.keyboard;
        if (n != 0) {
            return n;
        }
        n = this.keyboardHidden - that.keyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.hardKeyboardHidden - that.hardKeyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.navigation - that.navigation;
        if (n != 0) {
            return n;
        }
        n = this.navigationHidden - that.navigationHidden;
        if (n != 0) {
            return n;
        }
        n = this.orientation - that.orientation;
        if (n != 0) {
            return n;
        }
        n = this.screenLayout - that.screenLayout;
        return n;
    }

    public boolean equals(Configuration that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        return this.compareTo(that) == 0;
    }

    public boolean equals(Object that) {
        try {
            return this.equals((Configuration)that);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return (int)this.fontScale + this.mcc + this.mnc + this.locale.hashCode() + this.touchscreen + this.keyboard + this.keyboardHidden + this.hardKeyboardHidden + this.navigation + this.navigationHidden + this.orientation + this.screenLayout;
    }

    public /* synthetic */ Configuration(Parcel x0, 1 x1) {
        this(x0);
    }
}

