/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Path;
import com.android.tools.layoutlib.create.OverrideMethod;

public class PathMeasure {
    public static final int POSITION_MATRIX_FLAG = 1;
    public static final int TANGENT_MATRIX_FLAG = 2;
    public final int native_instance;

    public PathMeasure() {
        this.native_instance = PathMeasure.native_create(0, false);
    }

    public PathMeasure(Path path, boolean forceClosed) {
        this.native_instance = PathMeasure.native_create(path != null ? path.ni() : 0, forceClosed);
    }

    public void setPath(Path path, boolean forceClosed) {
        PathMeasure.native_setPath(this.native_instance, path != null ? path.ni() : 0, forceClosed);
    }

    public float getLength() {
        return PathMeasure.native_getLength(this.native_instance);
    }

    public boolean getPosTan(float distance, float[] pos, float[] tan) {
        if (pos != null && pos.length < 2 || tan != null && tan.length < 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return PathMeasure.native_getPosTan(this.native_instance, distance, pos, tan);
    }

    public boolean getMatrix(float distance, Matrix matrix, int flags) {
        return PathMeasure.native_getMatrix(this.native_instance, distance, matrix.native_instance, flags);
    }

    public boolean getSegment(float startD, float stopD, Path dst, boolean startWithMoveTo) {
        return PathMeasure.native_getSegment(this.native_instance, startD, stopD, dst.ni(), startWithMoveTo);
    }

    public boolean isClosed() {
        return PathMeasure.native_isClosed(this.native_instance);
    }

    public boolean nextContour() {
        return PathMeasure.native_nextContour(this.native_instance);
    }

    public void finalize() throws Throwable {
        PathMeasure.native_destroy(this.native_instance);
    }

    public static int native_create(int n, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_create(IZ)I", true, null);
    }

    public static void native_setPath(int n, int n2, boolean bl) {
        OverrideMethod.invokeV("android.graphics.PathMeasure#native_setPath(IIZ)V", true, null);
    }

    public static float native_getLength(int n) {
        return OverrideMethod.invokeF("android.graphics.PathMeasure#native_getLength(I)F", true, null);
    }

    public static boolean native_getPosTan(int n, float f, float[] fArray, float[] fArray2) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_getPosTan(IF[F[F)Z", true, null) != 0;
    }

    public static boolean native_getMatrix(int n, float f, int n2, int n3) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_getMatrix(IFII)Z", true, null) != 0;
    }

    public static boolean native_getSegment(int n, float f, float f2, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_getSegment(IFFIZ)Z", true, null) != 0;
    }

    public static boolean native_isClosed(int n) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_isClosed(I)Z", true, null) != 0;
    }

    public static boolean native_nextContour(int n) {
        return OverrideMethod.invokeI("android.graphics.PathMeasure#native_nextContour(I)Z", true, null) != 0;
    }

    public static void native_destroy(int n) {
        OverrideMethod.invokeV("android.graphics.PathMeasure#native_destroy(I)V", true, null);
    }
}

