/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RotateDrawable
extends Drawable
implements Drawable.Callback {
    public static final float MAX_LEVEL = 10000.0f;
    public RotateState mState;
    public boolean mMutated;

    public RotateDrawable() {
        this(null, null);
    }

    public RotateDrawable(RotateState rotateState, Resources res) {
        this.mState = new RotateState(rotateState, this, res);
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        Rect bounds = this.mState.mDrawable.getBounds();
        int w = bounds.right - bounds.left;
        int h = bounds.bottom - bounds.top;
        RotateState st = this.mState;
        float px = st.mPivotXRel ? (float)w * st.mPivotX : st.mPivotX;
        float py = st.mPivotYRel ? (float)h * st.mPivotY : st.mPivotY;
        canvas.rotate(st.mCurrentDegrees, px, py);
        st.mDrawable.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    public Drawable getDrawable() {
        return this.mState.mDrawable;
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations | this.mState.mDrawable.getChangingConfigurations();
    }

    public void setAlpha(int alpha) {
        this.mState.mDrawable.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mState.mDrawable.setColorFilter(cf);
    }

    public int getOpacity() {
        return this.mState.mDrawable.getOpacity();
    }

    public void invalidateDrawable(Drawable who) {
        if (this.mCallback != null) {
            this.mCallback.invalidateDrawable(this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (this.mCallback != null) {
            this.mCallback.scheduleDrawable(this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (this.mCallback != null) {
            this.mCallback.unscheduleDrawable(this, what);
        }
    }

    public boolean getPadding(Rect padding) {
        return this.mState.mDrawable.getPadding(padding);
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.mState.mDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    public boolean isStateful() {
        return this.mState.mDrawable.isStateful();
    }

    public boolean onStateChange(int[] state) {
        boolean changed = this.mState.mDrawable.setState(state);
        this.onBoundsChange(this.getBounds());
        return changed;
    }

    public boolean onLevelChange(int level) {
        this.mState.mDrawable.setLevel(level);
        this.onBoundsChange(this.getBounds());
        this.mState.mCurrentDegrees = this.mState.mFromDegrees + (this.mState.mToDegrees - this.mState.mFromDegrees) * ((float)level / 10000.0f);
        this.invalidateSelf();
        return true;
    }

    public void onBoundsChange(Rect bounds) {
        this.mState.mDrawable.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public int getIntrinsicWidth() {
        return this.mState.mDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mState.mDrawable.getIntrinsicHeight();
    }

    public Drawable.ConstantState getConstantState() {
        if (this.mState.canConstantState()) {
            this.mState.mChangingConfigurations = super.getChangingConfigurations();
            return this.mState;
        }
        return null;
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        TypedArray a = r.obtainAttributes(attrs, R.styleable.RotateDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        TypedValue tv = a.peekValue(4);
        boolean pivotXRel = tv.type == 6;
        float pivotX = pivotXRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        tv = a.peekValue(5);
        boolean pivotYRel = tv.type == 6;
        float pivotY = pivotYRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        float fromDegrees = a.getFloat(2, 0.0f);
        float toDegrees = a.getFloat(3, 360.0f);
        toDegrees = Math.max(fromDegrees, toDegrees);
        int res = a.getResourceId(1, 0);
        Drawable drawable2 = null;
        if (res > 0) {
            drawable2 = r.getDrawable(res);
        }
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2 || (drawable2 = Drawable.createFromXmlInner(r, parser, attrs)) != null) continue;
            Log.w("drawable", "Bad element under <rotate>: " + parser.getName());
        }
        if (drawable2 == null) {
            Log.w("drawable", "No drawable specified for <rotate>");
        }
        this.mState.mDrawable = drawable2;
        this.mState.mPivotXRel = pivotXRel;
        this.mState.mPivotX = pivotX;
        this.mState.mPivotYRel = pivotYRel;
        this.mState.mPivotY = pivotY;
        this.mState.mFromDegrees = this.mState.mCurrentDegrees = fromDegrees;
        this.mState.mToDegrees = toDegrees;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    public /* synthetic */ RotateDrawable(RotateState x0, Resources x1, 1 x2) {
        this(x0, x1);
    }

    public static class 1 {
    }

    public static class RotateState
    extends Drawable.ConstantState {
        public Drawable mDrawable;
        public int mChangingConfigurations;
        public boolean mPivotXRel;
        public float mPivotX;
        public boolean mPivotYRel;
        public float mPivotY;
        public float mFromDegrees;
        public float mToDegrees;
        public float mCurrentDegrees;
        public boolean mCanConstantState;
        public boolean mCheckedConstantState;

        public RotateState(RotateState source, RotateDrawable owner, Resources res) {
            if (source != null) {
                this.mDrawable = res != null ? source.mDrawable.getConstantState().newDrawable(res) : source.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(owner);
                this.mPivotXRel = source.mPivotXRel;
                this.mPivotX = source.mPivotX;
                this.mPivotYRel = source.mPivotYRel;
                this.mPivotY = source.mPivotY;
                this.mFromDegrees = this.mCurrentDegrees = source.mFromDegrees;
                this.mToDegrees = source.mToDegrees;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
            }
        }

        public Drawable newDrawable() {
            return new RotateDrawable(this, null, null);
        }

        public Drawable newDrawable(Resources res) {
            return new RotateDrawable(this, res, null);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }
    }
}

