/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.AndroidHttpClientConnection;
import android.net.http.EventHandler;
import android.net.http.HttpConnection;
import android.net.http.HttpsConnection;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestQueue;
import android.net.http.SSLConnectionClosedByUserException;
import android.net.http.SslCertificate;
import android.os.SystemClock;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Connection {
    public static final int SOCKET_TIMEOUT = 60000;
    public static final int SEND = 0;
    public static final int READ = 1;
    public static final int DRAIN = 2;
    public static final int DONE = 3;
    public static final String[] states = new String[]{"SEND", "READ", "DRAIN", "DONE"};
    public Context mContext;
    public AndroidHttpClientConnection mHttpClientConnection = null;
    public SslCertificate mCertificate = null;
    public HttpHost mHost;
    public boolean mCanPersist;
    public HttpContext mHttpContext;
    public static int STATE_NORMAL = 0;
    public static int STATE_CANCEL_REQUESTED = 1;
    public int mActive = STATE_NORMAL;
    public static final int RETRY_REQUEST_LIMIT = 2;
    public static final int MIN_PIPE = 2;
    public static final int MAX_PIPE = 3;
    public static final String HTTP_CONNECTION = "http.connection";
    public RequestQueue.ConnectionManager mConnectionManager;
    public RequestFeeder mRequestFeeder;
    public byte[] mBuf;

    public Connection(Context context, HttpHost host, RequestQueue.ConnectionManager connectionManager, RequestFeeder requestFeeder) {
        this.mContext = context;
        this.mHost = host;
        this.mConnectionManager = connectionManager;
        this.mRequestFeeder = requestFeeder;
        this.mCanPersist = false;
        this.mHttpContext = new BasicHttpContext(null);
    }

    public HttpHost getHost() {
        return this.mHost;
    }

    public static Connection getConnection(Context context, HttpHost host, RequestQueue.ConnectionManager connectionManager, RequestFeeder requestFeeder) {
        if (host.getSchemeName().equals("http")) {
            return new HttpConnection(context, host, connectionManager, requestFeeder);
        }
        return new HttpsConnection(context, host, connectionManager, requestFeeder);
    }

    public SslCertificate getCertificate() {
        return this.mCertificate;
    }

    public void cancel() {
        this.mActive = STATE_CANCEL_REQUESTED;
        this.closeConnection();
    }

    public void processRequests(Request firstRequest) {
        Request req = null;
        int error = 0;
        Throwable exception = null;
        LinkedList<Request> pipe = new LinkedList<Request>();
        int minPipe = 2;
        int maxPipe = 3;
        int state = 0;
        while (state != 3) {
            if (this.mActive == STATE_CANCEL_REQUESTED) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException x) {
                    // empty catch block
                }
                this.mActive = STATE_NORMAL;
            }
            switch (state) {
                case 0: {
                    if (pipe.size() == maxPipe) {
                        state = 1;
                        break;
                    }
                    if (firstRequest == null) {
                        req = this.mRequestFeeder.getRequest(this.mHost);
                    } else {
                        req = firstRequest;
                        firstRequest = null;
                    }
                    if (req == null) {
                        state = 2;
                        break;
                    }
                    req.setConnection(this);
                    if (req.mCancelled) {
                        req.complete();
                        break;
                    }
                    if (!(this.mHttpClientConnection != null && this.mHttpClientConnection.isOpen() || this.openHttpConnection(req))) {
                        state = 3;
                        break;
                    }
                    try {
                        req.sendRequest(this.mHttpClientConnection);
                    }
                    catch (HttpException e) {
                        exception = e;
                        error = -1;
                    }
                    catch (IOException e) {
                        exception = e;
                        error = -7;
                    }
                    catch (IllegalStateException e) {
                        exception = e;
                        error = -7;
                    }
                    if (exception != null) {
                        if (this.httpFailure(req, error, (Exception)exception) && !req.mCancelled) {
                            pipe.addLast(req);
                        }
                        exception = null;
                        state = this.clearPipe(pipe) ? 3 : 0;
                        maxPipe = 1;
                        minPipe = 1;
                        break;
                    }
                    pipe.addLast(req);
                    if (this.mCanPersist) break;
                    state = 1;
                    break;
                }
                case 1: 
                case 2: {
                    boolean empty = !this.mRequestFeeder.haveRequest(this.mHost);
                    int pipeSize = pipe.size();
                    if (state != 2 && pipeSize < minPipe && !empty && this.mCanPersist) {
                        state = 0;
                        break;
                    }
                    if (pipeSize == 0) {
                        state = empty ? 3 : 0;
                        break;
                    }
                    req = (Request)pipe.removeFirst();
                    try {
                        req.readResponse(this.mHttpClientConnection);
                    }
                    catch (ParseException e) {
                        exception = e;
                        error = -7;
                    }
                    catch (IOException e) {
                        exception = e;
                        error = -7;
                    }
                    catch (IllegalStateException e) {
                        exception = e;
                        error = -7;
                    }
                    if (exception != null) {
                        if (this.httpFailure(req, error, (Exception)exception) && !req.mCancelled) {
                            req.reset();
                            pipe.addFirst(req);
                        }
                        exception = null;
                        this.mCanPersist = false;
                    }
                    if (this.mCanPersist) break;
                    this.closeConnection();
                    this.mHttpContext.removeAttribute(HTTP_CONNECTION);
                    this.clearPipe(pipe);
                    maxPipe = 1;
                    minPipe = 1;
                    state = 0;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearPipe(LinkedList<Request> pipe) {
        boolean empty = true;
        RequestFeeder requestFeeder = this.mRequestFeeder;
        synchronized (requestFeeder) {
            while (!pipe.isEmpty()) {
                Request tReq = pipe.removeLast();
                this.mRequestFeeder.requeueRequest(tReq);
                empty = false;
            }
            if (empty) {
                empty = this.mRequestFeeder.haveRequest(this.mHost);
            }
        }
        return empty;
    }

    public boolean openHttpConnection(Request req) {
        long now = SystemClock.uptimeMillis();
        int error = 0;
        Exception exception = null;
        try {
            this.mCertificate = null;
            this.mHttpClientConnection = this.openConnection(req);
            if (this.mHttpClientConnection == null) {
                req.mFailCount = 2;
                return false;
            }
            this.mHttpClientConnection.setSocketTimeout(60000);
            this.mHttpContext.setAttribute(HTTP_CONNECTION, (Object)this.mHttpClientConnection);
        }
        catch (UnknownHostException e) {
            error = -2;
            exception = e;
        }
        catch (IllegalArgumentException e) {
            error = -6;
            req.mFailCount = 2;
            exception = e;
        }
        catch (SSLConnectionClosedByUserException e) {
            req.mFailCount = 2;
            return false;
        }
        catch (SSLHandshakeException e) {
            req.mFailCount = 2;
            error = -11;
            exception = e;
        }
        catch (IOException e) {
            error = -6;
            exception = e;
        }
        if (error == 0) {
            return true;
        }
        if (req.mFailCount < 2) {
            this.mRequestFeeder.requeueRequest(req);
            ++req.mFailCount;
        } else {
            this.httpFailure(req, error, exception);
        }
        return error == 0;
    }

    public boolean httpFailure(Request req, int errorId, Exception e) {
        boolean ret = true;
        if (++req.mFailCount >= 2) {
            Throwable cause;
            ret = false;
            String error = errorId < 0 ? ((Object)this.mContext.getText(EventHandler.errorStringResources[-errorId])).toString() : ((cause = e.getCause()) != null ? cause.toString() : e.getMessage());
            req.mEventHandler.error(errorId, error);
            req.complete();
        }
        this.closeConnection();
        this.mHttpContext.removeAttribute(HTTP_CONNECTION);
        return ret;
    }

    public HttpContext getHttpContext() {
        return this.mHttpContext;
    }

    public boolean keepAlive(HttpEntity entity, ProtocolVersion ver, int connType, HttpContext context) {
        org.apache.http.HttpConnection conn = (org.apache.http.HttpConnection)context.getAttribute(HTTP_CONNECTION);
        if (conn != null && !conn.isOpen()) {
            return false;
        }
        if (entity != null && entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0))) {
            return false;
        }
        if (connType == 1) {
            return false;
        }
        if (connType == 2) {
            return true;
        }
        return !ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0);
    }

    public void setCanPersist(HttpEntity entity, ProtocolVersion ver, int connType) {
        this.mCanPersist = this.keepAlive(entity, ver, connType, this.mHttpContext);
    }

    public void setCanPersist(boolean canPersist) {
        this.mCanPersist = canPersist;
    }

    public boolean getCanPersist() {
        return this.mCanPersist;
    }

    public abstract String getScheme();

    public abstract void closeConnection();

    public abstract AndroidHttpClientConnection openConnection(Request var1) throws IOException;

    public synchronized String toString() {
        return this.mHost.toString();
    }

    public byte[] getBuf() {
        if (this.mBuf == null) {
            this.mBuf = new byte[8192];
        }
        return this.mBuf;
    }
}

