/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.content.Context;
import android.opengl.GLDebugHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.Writer;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    public static final boolean LOG_THREADS = false;
    public static final boolean LOG_SURFACE = false;
    public static final boolean LOG_RENDERER = false;
    public static final boolean DRAW_TWICE_AFTER_SIZE_CHANGED = true;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    public static final GLThreadManager sGLThreadManager = new GLThreadManager(null);
    public boolean mSizeChanged = true;
    public GLThread mGLThread;
    public EGLConfigChooser mEGLConfigChooser;
    public EGLContextFactory mEGLContextFactory;
    public EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    public GLWrapper mGLWrapper;
    public int mDebugFlags;

    public GLSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void init() {
        SurfaceHolder holder = this.getHolder();
        holder.addCallback(this);
    }

    public void setGLWrapper(GLWrapper glWrapper) {
        this.mGLWrapper = glWrapper;
    }

    public void setDebugFlags(int debugFlags) {
        this.mDebugFlags = debugFlags;
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public void setRenderer(Renderer renderer) {
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            this.mEGLConfigChooser = new SimpleEGLConfigChooser(true);
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory(null);
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory(null);
        }
        this.mGLThread = new GLThread(renderer);
        this.mGLThread.start();
    }

    public void setEGLContextFactory(EGLContextFactory factory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = factory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory factory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = factory;
    }

    public void setEGLConfigChooser(EGLConfigChooser configChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = configChooser;
    }

    public void setEGLConfigChooser(boolean needDepth) {
        this.setEGLConfigChooser(new SimpleEGLConfigChooser(needDepth));
    }

    public void setEGLConfigChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
        this.setEGLConfigChooser(new ComponentSizeChooser(redSize, greenSize, blueSize, alphaSize, depthSize, stencilSize));
    }

    public void setRenderMode(int renderMode) {
        this.mGLThread.setRenderMode(renderMode);
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mGLThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mGLThread.surfaceDestroyed();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        this.mGLThread.onWindowResize(w, h);
    }

    public void onPause() {
        this.mGLThread.onPause();
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable r) {
        this.mGLThread.queueEvent(r);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mGLThread.requestExitAndWait();
    }

    public void checkRenderThreadState() {
        if (this.mGLThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    public static class 1 {
    }

    public static class GLThreadManager {
        public GLThread mEglOwner;

        public GLThreadManager() {
        }

        public synchronized void threadExiting(GLThread thread) {
            thread.mExited = true;
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public boolean tryAcquireEglSurfaceLocked(GLThread thread) {
            if (this.mEglOwner == thread || this.mEglOwner == null) {
                this.mEglOwner = thread;
                this.notifyAll();
                return true;
            }
            return false;
        }

        public void releaseEglSurfaceLocked(GLThread thread) {
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public /* synthetic */ GLThreadManager(1 x0) {
            this();
        }
    }

    public static class LogWriter
    extends Writer {
        public StringBuilder mBuilder = new StringBuilder();

        public void close() {
            this.flushBuilder();
        }

        public void flush() {
            this.flushBuilder();
        }

        public void write(char[] buf, int offset, int count) {
            for (int i = 0; i < count; ++i) {
                char c = buf[offset + i];
                if (c == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c);
            }
        }

        public void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Log.v("GLSurfaceView", this.mBuilder.toString());
                this.mBuilder.delete(0, this.mBuilder.length());
            }
        }
    }

    public class GLThread
    extends Thread {
        public boolean mShouldExit;
        public boolean mExited;
        public boolean mPaused;
        public boolean mHasSurface;
        public boolean mWaitingForSurface;
        public boolean mHaveEgl;
        public int mWidth = 0;
        public int mHeight = 0;
        public int mRenderMode = 1;
        public boolean mRequestRender = true;
        public boolean mRenderComplete;
        public ArrayList<Runnable> mEventQueue = new ArrayList();
        public Renderer mRenderer;
        public EglHelper mEglHelper;

        public GLThread(Renderer renderer) {
            this.mRenderer = renderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setName("GLThread " + this.getId());
            try {
                try {
                    this.guardedRun();
                }
                catch (InterruptedException interruptedException) {
                    Object var3_2 = null;
                    sGLThreadManager.threadExiting(this);
                }
                Object var3_1 = null;
                sGLThreadManager.threadExiting(this);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                sGLThreadManager.threadExiting(this);
                throw throwable;
            }
        }

        public void stopEglLocked() {
            if (this.mHaveEgl) {
                this.mHaveEgl = false;
                this.mEglHelper.destroySurface();
                this.mEglHelper.finish();
                sGLThreadManager.releaseEglSurfaceLocked(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void guardedRun() throws InterruptedException {
            this.mEglHelper = new EglHelper();
            try {
                GL10 gl = null;
                boolean createEglSurface = false;
                boolean sizeChanged = false;
                boolean wantRenderNotification = false;
                boolean doRenderNotification = false;
                int w = 0;
                int h = 0;
                Runnable event = null;
                while (true) {
                    GLThreadManager gLThreadManager = sGLThreadManager;
                    // MONITORENTER : gLThreadManager
                    while (true) {
                        if (this.mShouldExit) {
                            // MONITOREXIT : gLThreadManager
                            Object var12_10 = null;
                            GLThreadManager gLThreadManager2 = sGLThreadManager;
                            // MONITORENTER : gLThreadManager2
                            this.stopEglLocked();
                            // MONITOREXIT : gLThreadManager2
                            return;
                        }
                        if (!this.mEventQueue.isEmpty()) {
                            event = this.mEventQueue.remove(0);
                            break;
                        }
                        if (this.mHaveEgl && this.mPaused) {
                            this.stopEglLocked();
                        }
                        if (!this.mHasSurface && !this.mWaitingForSurface) {
                            if (this.mHaveEgl) {
                                this.stopEglLocked();
                            }
                            this.mWaitingForSurface = true;
                            sGLThreadManager.notifyAll();
                        }
                        if (this.mHasSurface && this.mWaitingForSurface) {
                            this.mWaitingForSurface = false;
                            sGLThreadManager.notifyAll();
                        }
                        if (doRenderNotification) {
                            wantRenderNotification = false;
                            doRenderNotification = false;
                            this.mRenderComplete = true;
                            sGLThreadManager.notifyAll();
                        }
                        if (!this.mPaused && this.mHasSurface && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1)) {
                            if (!this.mHaveEgl && sGLThreadManager.tryAcquireEglSurfaceLocked(this)) {
                                this.mHaveEgl = true;
                                this.mEglHelper.start();
                                createEglSurface = true;
                                sizeChanged = true;
                                sGLThreadManager.notifyAll();
                            }
                            if (this.mHaveEgl) {
                                if (GLSurfaceView.this.mSizeChanged) {
                                    sizeChanged = true;
                                    w = this.mWidth;
                                    h = this.mHeight;
                                    wantRenderNotification = true;
                                    GLSurfaceView.this.mSizeChanged = false;
                                } else {
                                    this.mRequestRender = false;
                                }
                                sGLThreadManager.notifyAll();
                                break;
                            }
                        }
                        sGLThreadManager.wait();
                    }
                    // MONITOREXIT : gLThreadManager
                    if (event != null) {
                        event.run();
                        event = null;
                        continue;
                    }
                    if (createEglSurface) {
                        gl = (GL10)this.mEglHelper.createSurface(GLSurfaceView.this.getHolder());
                        this.mRenderer.onSurfaceCreated(gl, this.mEglHelper.mEglConfig);
                        createEglSurface = false;
                    }
                    if (sizeChanged) {
                        this.mRenderer.onSurfaceChanged(gl, w, h);
                        sizeChanged = false;
                    }
                    this.mRenderer.onDrawFrame(gl);
                    if (!this.mEglHelper.swap()) {
                        // empty if block
                    }
                    if (!wantRenderNotification) continue;
                    doRenderNotification = true;
                }
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                GLThreadManager gLThreadManager = sGLThreadManager;
                // MONITORENTER : gLThreadManager
                this.stopEglLocked();
                // MONITOREXIT : gLThreadManager
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int renderMode) {
            if (0 > renderMode || renderMode > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderMode = renderMode;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mPaused = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mPaused = false;
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int w, int h) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = w;
                this.mHeight = h;
                GLSurfaceView.this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!(this.mExited || this.mPaused || this.mRenderComplete)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(Runnable r) {
            if (r == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mEventQueue.add(r);
                sGLThreadManager.notifyAll();
            }
        }
    }

    public class EglHelper {
        public EGL10 mEgl;
        public EGLDisplay mEglDisplay;
        public EGLSurface mEglSurface;
        public EGLConfig mEglConfig;
        public EGLContext mEglContext;

        public void start() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            int[] version = new int[2];
            this.mEgl.eglInitialize(this.mEglDisplay, version);
            this.mEglConfig = GLSurfaceView.this.mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
            this.mEglContext = GLSurfaceView.this.mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
            if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                throw new RuntimeException("createContext failed");
            }
            this.mEglSurface = null;
        }

        public GL createSurface(SurfaceHolder holder) {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLSurfaceView.this.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
            }
            this.mEglSurface = GLSurfaceView.this.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, holder);
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                this.throwEglException("createWindowSurface");
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                this.throwEglException("eglMakeCurrent");
            }
            GL gl = this.mEglContext.getGL();
            if (GLSurfaceView.this.mGLWrapper != null) {
                gl = GLSurfaceView.this.mGLWrapper.wrap(gl);
            }
            if ((GLSurfaceView.this.mDebugFlags & 3) != 0) {
                int configFlags = 0;
                LogWriter log = null;
                if ((GLSurfaceView.this.mDebugFlags & 1) != 0) {
                    configFlags |= 1;
                }
                if ((GLSurfaceView.this.mDebugFlags & 2) != 0) {
                    log = new LogWriter();
                }
                gl = GLDebugHelper.wrap(gl, configFlags, (Writer)log);
            }
            return gl;
        }

        public boolean swap() {
            this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface);
            return this.mEgl.eglGetError() != 12302;
        }

        public void destroySurface() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLSurfaceView.this.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                this.mEglSurface = null;
            }
        }

        public void finish() {
            if (this.mEglContext != null) {
                GLSurfaceView.this.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }

        public void throwEglException(String function) {
            throw new RuntimeException(function + " failed: " + this.mEgl.eglGetError());
        }
    }

    public static class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean withDepthBuffer) {
            super(4, 4, 4, 0, withDepthBuffer ? 16 : 0, 0);
            this.mRedSize = 5;
            this.mGreenSize = 6;
            this.mBlueSize = 5;
        }
    }

    public static class ComponentSizeChooser
    extends BaseConfigChooser {
        public int[] mValue = new int[1];
        public int mRedSize;
        public int mGreenSize;
        public int mBlueSize;
        public int mAlphaSize;
        public int mDepthSize;
        public int mStencilSize;

        public ComponentSizeChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            super(new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12344});
            this.mRedSize = redSize;
            this.mGreenSize = greenSize;
            this.mBlueSize = blueSize;
            this.mAlphaSize = alphaSize;
            this.mDepthSize = depthSize;
            this.mStencilSize = stencilSize;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            EGLConfig closestConfig = null;
            int closestDistance = 1000;
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                int distance = Math.abs(r - this.mRedSize) + Math.abs(g - this.mGreenSize) + Math.abs(b - this.mBlueSize) + Math.abs(a - this.mAlphaSize);
                if (distance >= closestDistance) continue;
                closestDistance = distance;
                closestConfig = config;
            }
            return closestConfig;
        }

        public int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }
    }

    public static abstract class BaseConfigChooser
    implements EGLConfigChooser {
        public int[] mConfigSpec;

        public BaseConfigChooser(int[] configSpec) {
            this.mConfigSpec = configSpec;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config);
            EGLConfig config = this.chooseConfig(egl, display, configs);
            if (config == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return config;
        }

        public abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    public static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        public DefaultWindowSurfaceFactory() {
        }

        public EGLSurface createWindowSurface(EGL10 egl, EGLDisplay display, EGLConfig config, Object nativeWindow) {
            return egl.eglCreateWindowSurface(display, config, nativeWindow, null);
        }

        public void destroySurface(EGL10 egl, EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }

        public /* synthetic */ DefaultWindowSurfaceFactory(1 x0) {
            this();
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    public static class DefaultContextFactory
    implements EGLContextFactory {
        public DefaultContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
            return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, null);
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }

        public /* synthetic */ DefaultContextFactory(1 x0) {
            this();
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface Renderer {
        public void onSurfaceCreated(GL10 var1, EGLConfig var2);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onDrawFrame(GL10 var1);
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }
}

