/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.widget.TextView;

public class Touch {
    public static void scrollTo(TextView widget, Layout layout2, int x, int y) {
        int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
        int top = layout2.getLineForVertical(y);
        int bottom = layout2.getLineForVertical(y + widget.getHeight() - padding);
        int left = Integer.MAX_VALUE;
        int right = 0;
        Layout.Alignment a = null;
        for (int i = top; i <= bottom; ++i) {
            left = (int)Math.min((float)left, layout2.getLineLeft(i));
            right = (int)Math.max((float)right, layout2.getLineRight(i));
            if (a != null) continue;
            a = layout2.getParagraphAlignment(i);
        }
        padding = widget.getTotalPaddingLeft() + widget.getTotalPaddingRight();
        int width = widget.getWidth();
        int diff = 0;
        if (right - left < width - padding) {
            if (a == Layout.Alignment.ALIGN_CENTER) {
                diff = (width - padding - (right - left)) / 2;
            } else if (a == Layout.Alignment.ALIGN_OPPOSITE) {
                diff = width - padding - (right - left);
            }
        }
        x = Math.min(x, right - (width - padding) - diff);
        x = Math.max(x, left - diff);
        widget.scrollTo(x, y);
    }

    public static int getMaxScrollX(TextView widget, Layout layout2, int y) {
        int top = layout2.getLineForVertical(y);
        int bottom = layout2.getLineForVertical(y + widget.getHeight() - widget.getTotalPaddingTop() - widget.getTotalPaddingBottom());
        int left = Integer.MAX_VALUE;
        int right = 0;
        for (int i = top; i <= bottom; ++i) {
            left = (int)Math.min((float)left, layout2.getLineLeft(i));
            right = (int)Math.max((float)right, layout2.getLineRight(i));
        }
        return right - left - widget.getWidth() - widget.getTotalPaddingLeft() - widget.getTotalPaddingRight();
    }

    public static boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                DragState[] ds = buffer.getSpans(0, buffer.length(), DragState.class);
                for (int i = 0; i < ds.length; ++i) {
                    buffer.removeSpan(ds[i]);
                }
                buffer.setSpan(new DragState(event.getX(), event.getY(), widget.getScrollX(), widget.getScrollY()), 0, 0, 17);
                return true;
            }
            case 1: {
                DragState[] ds = buffer.getSpans(0, buffer.length(), DragState.class);
                for (int i = 0; i < ds.length; ++i) {
                    buffer.removeSpan(ds[i]);
                }
                return ds.length > 0 && ds[0].mUsed;
            }
            case 2: {
                DragState[] ds = buffer.getSpans(0, buffer.length(), DragState.class);
                if (ds.length <= 0) break;
                if (!ds[0].mFarEnough) {
                    int slop = ViewConfiguration.get(widget.getContext()).getScaledTouchSlop();
                    if (Math.abs(event.getX() - ds[0].mX) >= (float)slop || Math.abs(event.getY() - ds[0].mY) >= (float)slop) {
                        ds[0].mFarEnough = true;
                    }
                }
                if (!ds[0].mFarEnough) break;
                ds[0].mUsed = true;
                float dx = ds[0].mX - event.getX();
                float dy = ds[0].mY - event.getY();
                ds[0].mX = event.getX();
                ds[0].mY = event.getY();
                int nx = widget.getScrollX() + (int)dx;
                int ny = widget.getScrollY() + (int)dy;
                int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
                Layout layout2 = widget.getLayout();
                ny = Math.min(ny, layout2.getHeight() - (widget.getHeight() - padding));
                ny = Math.max(ny, 0);
                int oldX = widget.getScrollX();
                int oldY = widget.getScrollY();
                Touch.scrollTo(widget, layout2, nx, ny);
                if (oldX != widget.getScrollX() || oldY != widget.getScrollY()) {
                    widget.cancelLongPress();
                }
                return true;
            }
        }
        return false;
    }

    public static int getInitialScrollX(TextView widget, Spannable buffer) {
        DragState[] ds = buffer.getSpans(0, buffer.length(), DragState.class);
        return ds.length > 0 ? ds[0].mScrollX : -1;
    }

    public static int getInitialScrollY(TextView widget, Spannable buffer) {
        DragState[] ds = buffer.getSpans(0, buffer.length(), DragState.class);
        return ds.length > 0 ? ds[0].mScrollY : -1;
    }

    public static class DragState
    implements NoCopySpan {
        public float mX;
        public float mY;
        public int mScrollX;
        public int mScrollY;
        public boolean mFarEnough;
        public boolean mUsed;

        public DragState(float x, float y, int scrollX, int scrollY) {
            this.mX = x;
            this.mY = y;
            this.mScrollX = scrollX;
            this.mScrollY = scrollY;
        }
    }
}

