/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view._Original_SurfaceView;
import java.util.ArrayList;

public class _Original_SurfaceView$2
implements SurfaceHolder {
    public static final String LOG_TAG = "SurfaceHolder";
    public int mSaveCount;
    public final /* synthetic */ _Original_SurfaceView this$0;

    public _Original_SurfaceView$2(_Original_SurfaceView _Original_SurfaceView2) {
        this.this$0 = _Original_SurfaceView2;
    }

    public boolean isCreating() {
        return this.this$0.mIsCreating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.this$0.mCallbacks;
        synchronized (arrayList) {
            if (!this.this$0.mCallbacks.contains(callback)) {
                this.this$0.mCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.this$0.mCallbacks;
        synchronized (arrayList) {
            this.this$0.mCallbacks.remove(callback);
        }
    }

    public void setFixedSize(int width, int height) {
        if (this.this$0.mRequestedWidth != width || this.this$0.mRequestedHeight != height) {
            this.this$0.mRequestedWidth = width;
            this.this$0.mRequestedHeight = height;
            this.this$0.requestLayout();
        }
    }

    public void setSizeFromLayout() {
        if (this.this$0.mRequestedWidth != -1 || this.this$0.mRequestedHeight != -1) {
            this.this$0.mRequestedHeight = -1;
            this.this$0.mRequestedWidth = -1;
            this.this$0.requestLayout();
        }
    }

    public void setFormat(int format) {
        this.this$0.mRequestedFormat = format;
        if (this.this$0.mWindow != null) {
            _Original_SurfaceView.access$000(this.this$0, false);
        }
    }

    public void setType(int type) {
        switch (type) {
            case 1: 
            case 2: {
                type = 0;
            }
        }
        switch (type) {
            case 0: 
            case 3: {
                this.this$0.mRequestedType = type;
                if (this.this$0.mWindow == null) break;
                _Original_SurfaceView.access$000(this.this$0, false);
            }
        }
    }

    public void setKeepScreenOn(boolean screenOn) {
        Message msg = this.this$0.mHandler.obtainMessage(1);
        msg.arg1 = screenOn ? 1 : 0;
        this.this$0.mHandler.sendMessage(msg);
    }

    public Canvas lockCanvas() {
        return this.internalLockCanvas(null);
    }

    public Canvas lockCanvas(Rect dirty) {
        return this.internalLockCanvas(dirty);
    }

    public Canvas internalLockCanvas(Rect dirty) {
        if (this.this$0.mType == 3) {
            throw new SurfaceHolder.BadSurfaceTypeException("Surface type is SURFACE_TYPE_PUSH_BUFFERS");
        }
        this.this$0.mSurfaceLock.lock();
        Canvas c = null;
        if (!this.this$0.mDrawingStopped && this.this$0.mWindow != null) {
            Rect frame = dirty != null ? dirty : this.this$0.mSurfaceFrame;
            try {
                c = this.this$0.mSurface.lockCanvas(frame);
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Exception locking surface", e);
            }
        }
        if (c != null) {
            this.this$0.mLastLockTime = SystemClock.uptimeMillis();
            return c;
        }
        long nextTime = this.this$0.mLastLockTime + 100L;
        long now = SystemClock.uptimeMillis();
        if (nextTime > now) {
            try {
                Thread.sleep(nextTime - now);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            now = SystemClock.uptimeMillis();
        }
        this.this$0.mLastLockTime = now;
        this.this$0.mSurfaceLock.unlock();
        return null;
    }

    public void unlockCanvasAndPost(Canvas canvas) {
        this.this$0.mSurface.unlockCanvasAndPost(canvas);
        this.this$0.mSurfaceLock.unlock();
    }

    public Surface getSurface() {
        return this.this$0.mSurface;
    }

    public Rect getSurfaceFrame() {
        return this.this$0.mSurfaceFrame;
    }
}

