/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.webkit.GeolocationPermissions;
import java.util.HashSet;

public class GoogleLocationSettingManager {
    public GoogleLocationSettingObserver mSettingObserver;
    public static final int sSystemSettingTrue = 1;
    public static final int sSystemSettingFalse = 0;
    public static final String LAST_READ_USE_LOCATION_FOR_SERVICES = "lastReadUseLocationForServices";
    public static final String BROWSER_PACKAGE_NAME = "com.android.browser";
    public static HashSet<String> sGoogleOrigins = new HashSet();
    public static GoogleLocationSettingManager sGoogleLocationSettingManager;
    public static int sRefCount;

    public static GoogleLocationSettingManager getInstance() {
        if (sGoogleLocationSettingManager == null) {
            sGoogleLocationSettingManager = new GoogleLocationSettingManager();
        }
        return sGoogleLocationSettingManager;
    }

    public void start(Context context) {
        if (context == null || !BROWSER_PACKAGE_NAME.equals(context.getPackageName())) {
            return;
        }
        ++sRefCount;
        if (this.mSettingObserver != null) {
            return;
        }
        this.maybeApplySetting(context);
        this.mSettingObserver = new GoogleLocationSettingObserver();
        this.mSettingObserver.observe(context);
    }

    public void stop() {
        if (this.mSettingObserver == null) {
            return;
        }
        if (--sRefCount == 0) {
            this.mSettingObserver.doNotObserve();
            this.mSettingObserver = null;
        }
    }

    public void maybeApplySetting(Context context) {
        int setting = this.getSystemSetting(context);
        if (this.settingChanged(setting, context)) {
            this.applySetting(setting);
        }
    }

    public int getSystemSetting(Context context) {
        return Settings.Secure.getInt(context.getContentResolver(), "use_location", 0);
    }

    public boolean settingChanged(int setting, Context context) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(context);
        int lastReadSetting = 0;
        if ((lastReadSetting = preferences.getInt(LAST_READ_USE_LOCATION_FOR_SERVICES, lastReadSetting)) == setting) {
            return false;
        }
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(LAST_READ_USE_LOCATION_FOR_SERVICES, setting);
        editor.commit();
        return true;
    }

    public void applySetting(int setting) {
        for (String origin : sGoogleOrigins) {
            if (setting == 1) {
                GeolocationPermissions.getInstance().allow(origin);
                continue;
            }
            GeolocationPermissions.getInstance().clear(origin);
        }
    }

    static {
        sGoogleOrigins.add("http://www.google.com");
        sGoogleOrigins.add("http://www.google.co.uk");
        sGoogleLocationSettingManager = null;
        sRefCount = 0;
    }

    public class GoogleLocationSettingObserver
    extends ContentObserver {
        public Context mContext;

        public GoogleLocationSettingObserver() {
            super(new Handler());
        }

        public void observe(Context context) {
            if (this.mContext != null) {
                return;
            }
            ContentResolver resolver = context.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor("use_location"), false, this);
            this.mContext = context;
        }

        public void doNotObserve() {
            if (this.mContext == null) {
                return;
            }
            ContentResolver resolver = this.mContext.getContentResolver();
            resolver.unregisterContentObserver(this);
            this.mContext = null;
        }

        public void onChange(boolean selfChange) {
            if (this.mContext != null) {
                GoogleLocationSettingManager.this.maybeApplySetting(this.mContext);
            }
        }
    }
}

