/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.webkit.CallbackProxy;

public class JsResult {
    public boolean mReady;
    public boolean mTriedToNotifyBeforeReady;
    public boolean mResult;
    public final CallbackProxy mProxy;
    public final boolean mDefaultValue;

    public void cancel() {
        this.mResult = false;
        this.wakeUp();
    }

    public void confirm() {
        this.mResult = true;
        this.wakeUp();
    }

    public JsResult(CallbackProxy proxy, boolean defaultVal) {
        this.mProxy = proxy;
        this.mDefaultValue = defaultVal;
    }

    public boolean getResult() {
        return this.mResult;
    }

    public void setReady() {
        this.mReady = true;
        if (this.mTriedToNotifyBeforeReady) {
            this.wakeUp();
        }
    }

    public void handleDefault() {
        this.setReady();
        this.mResult = this.mDefaultValue;
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        if (this.mReady) {
            CallbackProxy callbackProxy = this.mProxy;
            synchronized (callbackProxy) {
                this.mProxy.notify();
            }
        } else {
            this.mTriedToNotifyBeforeReady = true;
        }
    }
}

