/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Vector;

public class WebIconDatabase {
    public static WebIconDatabase sIconDatabase;
    public final EventHandler mEventHandler = new EventHandler(null);

    public void open(String path) {
        if (path != null) {
            this.mEventHandler.postMessage(Message.obtain(null, 0, path));
        }
    }

    public void close() {
        this.mEventHandler.postMessage(Message.obtain(null, 1));
    }

    public void removeAllIcons() {
        this.mEventHandler.postMessage(Message.obtain(null, 2));
    }

    public void requestIconForPageUrl(String url, IconListener listener) {
        if (listener == null || url == null) {
            return;
        }
        Message msg = Message.obtain(null, 3, listener);
        msg.getData().putString("url", url);
        this.mEventHandler.postMessage(msg);
    }

    public void retainIconForPageUrl(String url) {
        if (url != null) {
            this.mEventHandler.postMessage(Message.obtain(null, 4, url));
        }
    }

    public void releaseIconForPageUrl(String url) {
        if (url != null) {
            this.mEventHandler.postMessage(Message.obtain(null, 5, url));
        }
    }

    public static WebIconDatabase getInstance() {
        if (sIconDatabase == null) {
            sIconDatabase = new WebIconDatabase();
        }
        return sIconDatabase;
    }

    public void createHandler() {
        this.mEventHandler.createHandler();
    }

    public static void nativeOpen(String string2) {
        OverrideMethod.invokeV("android.webkit.WebIconDatabase#nativeOpen(Ljava/lang/String;)V", true, null);
    }

    public static void nativeClose() {
        OverrideMethod.invokeV("android.webkit.WebIconDatabase#nativeClose()V", true, null);
    }

    public static void nativeRemoveAllIcons() {
        OverrideMethod.invokeV("android.webkit.WebIconDatabase#nativeRemoveAllIcons()V", true, null);
    }

    public static Bitmap nativeIconForPageUrl(String string2) {
        return (Bitmap)OverrideMethod.invokeA("android.webkit.WebIconDatabase#nativeIconForPageUrl(Ljava/lang/String;)Landroid/graphics/Bitmap;", true, null);
    }

    public static void nativeRetainIconForPageUrl(String string2) {
        OverrideMethod.invokeV("android.webkit.WebIconDatabase#nativeRetainIconForPageUrl(Ljava/lang/String;)V", true, null);
    }

    public static void nativeReleaseIconForPageUrl(String string2) {
        OverrideMethod.invokeV("android.webkit.WebIconDatabase#nativeReleaseIconForPageUrl(Ljava/lang/String;)V", true, null);
    }

    public static class 1 {
    }

    public static interface IconListener {
        public void onReceivedIcon(String var1, Bitmap var2);
    }

    public static class EventHandler
    extends Handler {
        public static final int OPEN = 0;
        public static final int CLOSE = 1;
        public static final int REMOVE_ALL = 2;
        public static final int REQUEST_ICON = 3;
        public static final int RETAIN_ICON = 4;
        public static final int RELEASE_ICON = 5;
        public static final int ICON_RESULT = 10;
        public Handler mHandler;
        public Vector<Message> mMessages = new Vector();

        public EventHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 10: {
                    ((IconResult)msg.obj).dispatch();
                }
            }
        }

        public synchronized void createHandler() {
            if (this.mHandler == null) {
                this.mHandler = new Handler(){

                    public void handleMessage(Message msg) {
                        switch (msg.what) {
                            case 0: {
                                WebIconDatabase.nativeOpen((String)msg.obj);
                                break;
                            }
                            case 1: {
                                WebIconDatabase.nativeClose();
                                break;
                            }
                            case 2: {
                                WebIconDatabase.nativeRemoveAllIcons();
                                break;
                            }
                            case 3: {
                                IconListener l = (IconListener)msg.obj;
                                String url = msg.getData().getString("url");
                                Bitmap icon = WebIconDatabase.nativeIconForPageUrl(url);
                                if (icon == null) break;
                                EventHandler.this.sendMessage(Message.obtain(null, 10, new IconResult(url, icon, l)));
                                break;
                            }
                            case 4: {
                                WebIconDatabase.nativeRetainIconForPageUrl((String)msg.obj);
                                break;
                            }
                            case 5: {
                                WebIconDatabase.nativeReleaseIconForPageUrl((String)msg.obj);
                            }
                        }
                    }
                };
                for (int size = this.mMessages.size(); size > 0; --size) {
                    this.mHandler.sendMessage(this.mMessages.remove(0));
                }
                this.mMessages = null;
            }
        }

        public synchronized void postMessage(Message msg) {
            if (this.mMessages != null) {
                this.mMessages.add(msg);
            } else {
                this.mHandler.sendMessage(msg);
            }
        }

        public /* synthetic */ EventHandler(1 x0) {
            this();
        }

        public class IconResult {
            public final String mUrl;
            public final Bitmap mIcon;
            public final IconListener mListener;

            public IconResult(String url, Bitmap icon, IconListener l) {
                this.mUrl = url;
                this.mIcon = icon;
                this.mListener = l;
            }

            public void dispatch() {
                this.mListener.onReceivedIcon(this.mUrl, this.mIcon);
            }
        }
    }
}

