/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import com.android.internal.telephony.ATParseEx;

public class ATResponseParser {
    public String line;
    public int next = 0;
    public int tokStart;
    public int tokEnd;

    public ATResponseParser(String line) {
        this.line = line;
    }

    public boolean nextBoolean() {
        this.nextTok();
        if (this.tokEnd - this.tokStart > 1) {
            throw new ATParseEx();
        }
        char c = this.line.charAt(this.tokStart);
        if (c == '0') {
            return false;
        }
        if (c == '1') {
            return true;
        }
        throw new ATParseEx();
    }

    public int nextInt() {
        int ret = 0;
        this.nextTok();
        for (int i = this.tokStart; i < this.tokEnd; ++i) {
            char c = this.line.charAt(i);
            if (c < '0' || c > '9') {
                throw new ATParseEx();
            }
            ret *= 10;
            ret += c - 48;
        }
        return ret;
    }

    public String nextString() {
        this.nextTok();
        return this.line.substring(this.tokStart, this.tokEnd);
    }

    public boolean hasMore() {
        return this.next < this.line.length();
    }

    public void nextTok() {
        block12: {
            int len = this.line.length();
            if (this.next == 0) {
                this.skipPrefix();
            }
            if (this.next >= len) {
                throw new ATParseEx();
            }
            try {
                char c = this.line.charAt(this.next++);
                boolean hasQuote = false;
                c = this.skipWhiteSpace(c);
                if (c == '\"') {
                    if (this.next >= len) {
                        throw new ATParseEx();
                    }
                    c = this.line.charAt(this.next++);
                    this.tokStart = this.next - 1;
                    while (c != '\"' && this.next < len) {
                        c = this.line.charAt(this.next++);
                    }
                    if (c != '\"') {
                        throw new ATParseEx();
                    }
                    this.tokEnd = this.next - 1;
                    if (this.next < len && this.line.charAt(this.next++) != ',') {
                        throw new ATParseEx();
                    }
                    break block12;
                }
                this.tokEnd = this.tokStart = this.next - 1;
                while (c != ',') {
                    if (!Character.isWhitespace(c)) {
                        this.tokEnd = this.next;
                    }
                    if (this.next != len) {
                        c = this.line.charAt(this.next++);
                        continue;
                    }
                    break;
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new ATParseEx();
            }
        }
    }

    public char skipWhiteSpace(char c) {
        int len = this.line.length();
        while (this.next < len && Character.isWhitespace(c)) {
            c = this.line.charAt(this.next++);
        }
        if (Character.isWhitespace(c)) {
            throw new ATParseEx();
        }
        return c;
    }

    public void skipPrefix() {
        this.next = 0;
        int s = this.line.length();
        while (this.next < s) {
            char c;
            if ((c = this.line.charAt(this.next++)) != ':') continue;
            return;
        }
        throw new ATParseEx("missing prefix");
    }
}

