/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.text.util.Regex;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataLinkInterface;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.telephony.gsm.GSMPhone;

public class PdpConnection
extends DataConnection {
    public static final String LOG_TAG = "GSM";
    public static final boolean DBG = true;
    public static final int PDP_FAIL_OPERATOR_BARRED = 8;
    public static final int PDP_FAIL_INSUFFICIENT_RESOURCES = 26;
    public static final int PDP_FAIL_MISSING_UKNOWN_APN = 27;
    public static final int PDP_FAIL_UNKNOWN_PDP_ADDRESS_TYPE = 28;
    public static final int PDP_FAIL_USER_AUTHENTICATION = 29;
    public static final int PDP_FAIL_ACTIVATION_REJECT_GGSN = 30;
    public static final int PDP_FAIL_ACTIVATION_REJECT_UNSPECIFIED = 31;
    public static final int PDP_FAIL_SERVICE_OPTION_NOT_SUPPORTED = 32;
    public static final int PDP_FAIL_SERVICE_OPTION_NOT_SUBSCRIBED = 33;
    public static final int PDP_FAIL_SERVICE_OPTION_OUT_OF_ORDER = 34;
    public static final int PDP_FAIL_NSAPI_IN_USE = 35;
    public static final int PDP_FAIL_PROTOCOL_ERRORS = 111;
    public static final int PDP_FAIL_ERROR_UNSPECIFIED = 65535;
    public static final int PDP_FAIL_REGISTRATION_FAIL = -1;
    public static final int PDP_FAIL_GPRS_REGISTRATION_FAIL = -2;
    public String pdp_name;
    public ApnSetting apn;

    public PdpConnection(GSMPhone phone) {
        super(phone);
    }

    public void connect(ApnSetting apn, Message onCompleted) {
        this.log("Connecting to carrier: '" + apn.carrier + "' APN: '" + apn.apn + "' proxy: '" + apn.proxy + "' port: '" + apn.port);
        this.setHttpProxy(apn.proxy, apn.port);
        this.state = DataConnection.State.ACTIVATING;
        this.apn = apn;
        this.onConnectCompleted = onCompleted;
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = DataConnection.FailCause.NONE;
        this.receivedDisconnectReq = false;
        int authType = apn.authType;
        if (authType == -1) {
            authType = apn.user != null ? 3 : 0;
        }
        this.phone.mCM.setupDataCall(Integer.toString(1), Integer.toString(0), apn.apn, apn.user, apn.password, Integer.toString(authType), this.obtainMessage(1));
    }

    public void tearDownData(Message msg) {
        if (this.phone.mCM.getRadioState().isOn()) {
            this.phone.mCM.deactivateDataCall(this.cid, this.obtainMessage(4, msg));
        }
    }

    public void disconnect(Message msg) {
        this.onDisconnect = msg;
        if (this.state == DataConnection.State.ACTIVE) {
            this.tearDownData(msg);
        } else if (this.state == DataConnection.State.ACTIVATING) {
            this.receivedDisconnectReq = true;
        } else {
            this.notifyDisconnect(msg);
        }
    }

    public void clearSettings() {
        super.clearSettings();
        this.apn = null;
    }

    public String toString() {
        return "State=" + (Object)((Object)this.state) + " Apn=" + this.apn + " create=" + this.createTime + " lastFail=" + this.lastFailTime + " lastFailCause=" + (Object)((Object)this.lastFailCause);
    }

    public void notifyFail(DataConnection.FailCause cause, Message onCompleted) {
        if (onCompleted == null) {
            return;
        }
        this.state = DataConnection.State.INACTIVE;
        this.lastFailCause = cause;
        this.lastFailTime = System.currentTimeMillis();
        this.onConnectCompleted = null;
        this.log("Notify PDP fail at " + this.lastFailTime + " due to " + (Object)((Object)this.lastFailCause));
        AsyncResult.forMessage(onCompleted, (Object)cause, new Exception());
        onCompleted.sendToTarget();
    }

    public void notifySuccess(Message onCompleted) {
        if (onCompleted == null) {
            return;
        }
        this.state = DataConnection.State.ACTIVE;
        this.createTime = System.currentTimeMillis();
        this.onConnectCompleted = null;
        onCompleted.arg1 = this.cid;
        this.log("Notify PDP success at " + this.createTime);
        AsyncResult.forMessage(onCompleted);
        onCompleted.sendToTarget();
    }

    public void notifyDisconnect(Message msg) {
        this.log("Notify PDP disconnect");
        if (msg != null) {
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
        this.clearSettings();
    }

    public void onLinkStateChanged(DataLinkInterface.LinkState linkState) {
        switch (linkState) {
            case LINK_UP: {
                this.notifySuccess(this.onConnectCompleted);
                break;
            }
            case LINK_DOWN: 
            case LINK_EXITED: {
                this.phone.mCM.getLastPdpFailCause(this.obtainMessage(2));
            }
        }
    }

    public DataConnection.FailCause getFailCauseFromRequest(int rilCause) {
        DataConnection.FailCause cause;
        switch (rilCause) {
            case 8: {
                cause = DataConnection.FailCause.OPERATOR_BARRED;
                break;
            }
            case 26: {
                cause = DataConnection.FailCause.INSUFFICIENT_RESOURCES;
                break;
            }
            case 27: {
                cause = DataConnection.FailCause.MISSING_UKNOWN_APN;
                break;
            }
            case 28: {
                cause = DataConnection.FailCause.UNKNOWN_PDP_ADDRESS;
                break;
            }
            case 29: {
                cause = DataConnection.FailCause.USER_AUTHENTICATION;
                break;
            }
            case 30: {
                cause = DataConnection.FailCause.ACTIVATION_REJECT_GGSN;
                break;
            }
            case 31: {
                cause = DataConnection.FailCause.ACTIVATION_REJECT_UNSPECIFIED;
                break;
            }
            case 34: {
                cause = DataConnection.FailCause.SERVICE_OPTION_OUT_OF_ORDER;
                break;
            }
            case 32: {
                cause = DataConnection.FailCause.SERVICE_OPTION_NOT_SUPPORTED;
                break;
            }
            case 33: {
                cause = DataConnection.FailCause.SERVICE_OPTION_NOT_SUBSCRIBED;
                break;
            }
            case 35: {
                cause = DataConnection.FailCause.NSAPI_IN_USE;
                break;
            }
            case 111: {
                cause = DataConnection.FailCause.PROTOCOL_ERRORS;
                break;
            }
            case 65535: {
                cause = DataConnection.FailCause.UNKNOWN;
                break;
            }
            case -1: {
                cause = DataConnection.FailCause.REGISTRATION_FAIL;
                break;
            }
            case -2: {
                cause = DataConnection.FailCause.GPRS_REGISTRATION_FAIL;
                break;
            }
            default: {
                cause = DataConnection.FailCause.UNKNOWN;
            }
        }
        return cause;
    }

    public void log(String s) {
        Log.d(LOG_TAG, "[PdpConnection] " + s);
    }

    public void onDeactivated(AsyncResult ar) {
        this.notifyDisconnect((Message)ar.userObj);
        this.log("PDP Connection Deactivated");
    }

    public void onSetupConnectionCompleted(AsyncResult ar) {
        if (ar.exception != null) {
            Log.e(LOG_TAG, "PDP Context Init failed " + ar.exception);
            if (this.receivedDisconnectReq) {
                this.notifyDisconnect(this.onDisconnect);
            } else if (ar.exception instanceof CommandException && ((CommandException)ar.exception).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE) {
                this.notifyFail(DataConnection.FailCause.RADIO_NOT_AVAILABLE, this.onConnectCompleted);
            } else {
                this.phone.mCM.getLastPdpFailCause(this.obtainMessage(2));
            }
        } else if (this.receivedDisconnectReq) {
            this.tearDownData(this.onDisconnect);
        } else {
            String[] response = (String[])ar.result;
            this.cid = Integer.parseInt(response[0]);
            if (response.length > 2) {
                this.interfaceName = response[1];
                this.ipAddress = response[2];
                String prefix = "net." + this.interfaceName + ".";
                this.gatewayAddress = SystemProperties.get(prefix + "gw");
                this.dnsServers[0] = SystemProperties.get(prefix + "dns1");
                this.dnsServers[1] = SystemProperties.get(prefix + "dns2");
                this.log("interface=" + this.interfaceName + " ipAddress=" + this.ipAddress + " gateway=" + this.gatewayAddress + " DNS1=" + this.dnsServers[0] + " DNS2=" + this.dnsServers[1]);
                if (!(!"0.0.0.0".equals(this.dnsServers[0]) || !"0.0.0.0".equals(this.dnsServers[1]) || ((GSMPhone)this.phone).isDnsCheckDisabled() || this.apn.types[0].equals("mms") && this.isIpAddress(this.apn.mmsProxy))) {
                    EventLog.writeEvent(50100, this.dnsServers[0]);
                    this.phone.mCM.deactivateDataCall(this.cid, this.obtainMessage(5));
                    return;
                }
            }
            this.onLinkStateChanged(DataLinkInterface.LinkState.LINK_UP);
            this.log("PDP setup on cid = " + this.cid);
        }
    }

    public boolean isIpAddress(String address) {
        if (address == null) {
            return false;
        }
        return Regex.IP_ADDRESS_PATTERN.matcher(this.apn.mmsProxy).matches();
    }

    public ApnSetting getApn() {
        return this.apn;
    }
}

