/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x501;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1SetOf;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.DerInputStream;
import org.apache.harmony.security.internal.nls.Messages;
import org.apache.harmony.security.x501.AttributeTypeAndValue;
import org.apache.harmony.security.x501.AttributeTypeAndValueComparator;
import org.apache.harmony.security.x509.DNParser;

public class Name {
    public volatile byte[] encoded;
    public String rfc1779String;
    public String rfc2253String;
    public String canonicalString;
    public List rdn;
    public static final ASN1SetOf ASN1_RDN = new ASN1SetOf(AttributeTypeAndValue.ASN1);
    public static final ASN1SequenceOf ASN1 = new ASN1SequenceOf(ASN1_RDN){

        public Object getDecodedObject(BerInputStream in) {
            return new Name((List)in.content, null);
        }

        public Collection getValues(Object object) {
            return ((Name)object).rdn;
        }
    };

    public Name(byte[] encoding) throws IOException {
        DerInputStream in = new DerInputStream(encoding);
        if (in.getEndOffset() != encoding.length) {
            throw new IOException(Messages.getString("security.111"));
        }
        ASN1.decode(in);
        this.rdn = (List)in.content;
    }

    public Name(String name) throws IOException {
        this.rdn = new DNParser(name).parse();
    }

    public Name(List rdn) {
        this.rdn = rdn;
    }

    public X500Principal getX500Principal() {
        return new X500Principal(this.getName0("RFC2253"));
    }

    public String getName(String format) {
        if (format == "RFC1779") {
            if (this.rfc1779String == null) {
                this.rfc1779String = this.getName0(format);
            }
            return this.rfc1779String;
        }
        if (format == "RFC2253") {
            if (this.rfc2253String == null) {
                this.rfc2253String = this.getName0(format);
            }
            return this.rfc2253String;
        }
        if (format == "CANONICAL") {
            if (this.canonicalString == null) {
                this.canonicalString = this.getName0(format);
            }
            return this.canonicalString;
        }
        if ("RFC1779".equalsIgnoreCase(format)) {
            if (this.rfc1779String == null) {
                this.rfc1779String = this.getName0("RFC1779");
            }
            return this.rfc1779String;
        }
        if ("RFC2253".equalsIgnoreCase(format)) {
            if (this.rfc2253String == null) {
                this.rfc2253String = this.getName0("RFC2253");
            }
            return this.rfc2253String;
        }
        if ("CANONICAL".equalsIgnoreCase(format)) {
            if (this.canonicalString == null) {
                this.canonicalString = this.getName0("CANONICAL");
            }
            return this.canonicalString;
        }
        throw new IllegalArgumentException(Messages.getString("security.177", format));
    }

    public String getName0(String format) {
        StringBuffer name = new StringBuffer();
        for (int i = this.rdn.size() - 1; i >= 0; --i) {
            LinkedList atavList = (LinkedList)this.rdn.get(i);
            if ("CANONICAL" == format) {
                LinkedList sortedList = new LinkedList(atavList);
                Collections.sort(sortedList, new AttributeTypeAndValueComparator());
                atavList = sortedList;
            }
            Iterator it = atavList.iterator();
            while (it.hasNext()) {
                AttributeTypeAndValue _ava = (AttributeTypeAndValue)it.next();
                _ava.appendName(format, name);
                if (!it.hasNext()) continue;
                if ("RFC1779" == format) {
                    name.append(" + ");
                    continue;
                }
                name.append('+');
            }
            if (i == 0) continue;
            name.append(',');
            if (format != "RFC1779") continue;
            name.append(' ');
        }
        String sName = name.toString();
        if (format == "CANONICAL") {
            sName = sName.toLowerCase(Locale.US);
        }
        return sName;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encoded = ASN1.encode(this);
        }
        return this.encoded;
    }

    public /* synthetic */ Name(List x0, 1 x1) {
        this(x0);
    }
}

