/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import org.apache.harmony.xnet.provider.jsse.Logger;
import org.apache.harmony.xnet.provider.jsse.SSLRecordProtocol;

public class AlertProtocol {
    public static final byte WARNING = 1;
    public static final byte FATAL = 2;
    public static final byte CLOSE_NOTIFY = 0;
    public static final byte UNEXPECTED_MESSAGE = 10;
    public static final byte BAD_RECORD_MAC = 20;
    public static final byte DECRYPTION_FAILED = 21;
    public static final byte RECORD_OVERFLOW = 22;
    public static final byte DECOMPRESSION_FAILURE = 30;
    public static final byte HANDSHAKE_FAILURE = 40;
    public static final byte BAD_CERTIFICATE = 42;
    public static final byte UNSUPPORTED_CERTIFICATE = 43;
    public static final byte CERTIFICATE_REVOKED = 44;
    public static final byte CERTIFICATE_EXPIRED = 45;
    public static final byte CERTIFICATE_UNKNOWN = 46;
    public static final byte ILLEGAL_PARAMETER = 47;
    public static final byte UNKNOWN_CA = 48;
    public static final byte ACCESS_DENIED = 49;
    public static final byte DECODE_ERROR = 50;
    public static final byte DECRYPT_ERROR = 51;
    public static final byte EXPORT_RESTRICTION = 60;
    public static final byte PROTOCOL_VERSION = 70;
    public static final byte INSUFFICIENT_SECURITY = 71;
    public static final byte INTERNAL_ERROR = 80;
    public static final byte USER_CANCELED = 90;
    public static final byte NO_RENEGOTIATION = 100;
    public final byte[] alert = new byte[2];
    public SSLRecordProtocol recordProtocol;
    public Logger.Stream logger = Logger.getStream("alert");

    public void setRecordProtocol(SSLRecordProtocol recordProtocol) {
        this.recordProtocol = recordProtocol;
    }

    public void alert(byte level, byte description) {
        if (this.logger != null) {
            this.logger.println("Alert.alert: " + level + " " + description);
        }
        this.alert[0] = level;
        this.alert[1] = description;
    }

    public byte getDescriptionCode() {
        return this.alert[0] != 0 ? this.alert[1] : (byte)-100;
    }

    public void setProcessed() {
        if (this.logger != null) {
            this.logger.println("Alert.setProcessed");
        }
        this.alert[0] = 0;
    }

    public boolean hasAlert() {
        return this.alert[0] != 0;
    }

    public boolean isFatalAlert() {
        return this.alert[0] == 2;
    }

    public String getAlertDescription() {
        switch (this.alert[1]) {
            case 0: {
                return "close_notify";
            }
            case 10: {
                return "unexpected_message";
            }
            case 20: {
                return "bad_record_mac";
            }
            case 21: {
                return "decryption_failed";
            }
            case 22: {
                return "record_overflow";
            }
            case 30: {
                return "decompression_failure";
            }
            case 40: {
                return "handshake_failure";
            }
            case 42: {
                return "bad_certificate";
            }
            case 43: {
                return "unsupported_certificate";
            }
            case 44: {
                return "certificate_revoked";
            }
            case 45: {
                return "certificate_expired";
            }
            case 46: {
                return "certificate_unknown";
            }
            case 47: {
                return "illegal_parameter";
            }
            case 48: {
                return "unknown_ca";
            }
            case 49: {
                return "access_denied";
            }
            case 50: {
                return "decode_error";
            }
            case 51: {
                return "decrypt_error";
            }
            case 60: {
                return "export_restriction";
            }
            case 70: {
                return "protocol_version";
            }
            case 71: {
                return "insufficient_security";
            }
            case 80: {
                return "internal_error";
            }
            case 90: {
                return "user_canceled";
            }
            case 100: {
                return "no_renegotiation";
            }
        }
        return null;
    }

    public byte[] wrap() {
        byte[] res = this.recordProtocol.wrap((byte)21, this.alert, 0, 2);
        return res;
    }

    public void shutdown() {
        this.alert[0] = 0;
        this.alert[1] = 0;
        this.recordProtocol = null;
    }
}

