/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;
import org.apache.harmony.xnet.provider.jsse.AlertException;
import org.apache.harmony.xnet.provider.jsse.Appendable;
import org.apache.harmony.xnet.provider.jsse.DataStream;
import org.apache.harmony.xnet.provider.jsse.EndOfBufferException;
import org.apache.harmony.xnet.provider.jsse.SSLInputStream;

public class HandshakeIODataStream
extends SSLInputStream
implements Appendable,
DataStream {
    public static final MessageDigest md5;
    public static final MessageDigest sha;
    public int buff_size = 1024;
    public int inc_buff_size = 1024;
    public byte[] buffer = new byte[this.buff_size];
    public int read_pos;
    public int marked_pos;
    public int read_pos_end;
    public int write_pos;
    public int write_pos_beg;

    public int available() {
        return this.read_pos_end - this.read_pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int limit) {
        this.marked_pos = this.read_pos;
    }

    public void mark() {
        this.marked_pos = this.read_pos;
    }

    public void reset() {
        this.read_pos = this.marked_pos;
    }

    public void removeFromMarkedPosition() {
        System.arraycopy(this.buffer, this.read_pos, this.buffer, this.marked_pos, this.read_pos_end - this.read_pos);
        this.read_pos_end -= this.read_pos - this.marked_pos;
        this.read_pos = this.marked_pos;
    }

    public int read() throws IOException {
        if (this.read_pos == this.read_pos_end) {
            throw new EndOfBufferException();
        }
        return this.buffer[this.read_pos++] & 0xFF;
    }

    public byte[] read(int length) throws IOException {
        if (length > this.available()) {
            throw new EndOfBufferException();
        }
        byte[] res = new byte[length];
        System.arraycopy(this.buffer, this.read_pos, res, 0, length);
        this.read_pos += length;
        return res;
    }

    public int read(byte[] dest, int offset, int length) throws IOException {
        if (length > this.available()) {
            throw new EndOfBufferException();
        }
        System.arraycopy(this.buffer, this.read_pos, dest, offset, length);
        this.read_pos += length;
        return length;
    }

    public void append(byte[] src) {
        this.append(src, 0, src.length);
    }

    public void append(byte[] src, int from, int length) {
        if (this.read_pos == this.read_pos_end) {
            if (this.write_pos_beg != this.write_pos) {
                throw new AlertException(10, new SSLHandshakeException("Handshake message has been received before the last oubound message had been sent."));
            }
            if (this.read_pos < this.write_pos) {
                this.read_pos_end = this.read_pos = this.write_pos;
            }
        }
        if (this.read_pos_end + length > this.buff_size) {
            this.enlargeBuffer(this.read_pos_end + length - this.buff_size);
        }
        System.arraycopy(src, from, this.buffer, this.read_pos_end, length);
        this.read_pos_end += length;
    }

    public void enlargeBuffer(int size) {
        this.buff_size = size < this.inc_buff_size ? this.buff_size + this.inc_buff_size : this.buff_size + size;
        byte[] new_buff = new byte[this.buff_size];
        System.arraycopy(this.buffer, 0, new_buff, 0, this.buffer.length);
        this.buffer = new_buff;
    }

    public void clearBuffer() {
        this.read_pos = 0;
        this.marked_pos = 0;
        this.read_pos_end = 0;
        this.write_pos = 0;
        this.write_pos_beg = 0;
        Arrays.fill(this.buffer, (byte)0);
    }

    public void check(int length) {
        if (this.write_pos == this.write_pos_beg) {
            if (this.read_pos != this.read_pos_end) {
                throw new AlertException(80, new SSLHandshakeException("Data was not fully read: " + this.read_pos + " " + this.read_pos_end));
            }
            if (this.write_pos_beg < this.read_pos_end) {
                this.write_pos = this.write_pos_beg = this.read_pos_end;
            }
        }
        if (this.write_pos + length >= this.buff_size) {
            this.enlargeBuffer(length);
        }
    }

    public void write(byte b) {
        this.check(1);
        this.buffer[this.write_pos++] = b;
    }

    public void writeUint8(long n) {
        this.check(1);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void writeUint16(long n) {
        this.check(2);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00L) >> 8);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void writeUint24(long n) {
        this.check(3);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF0000L) >> 16);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00L) >> 8);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void writeUint32(long n) {
        this.check(4);
        this.buffer[this.write_pos++] = (byte)((n & 0xFFFFFFFFFF000000L) >> 24);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF0000L) >> 16);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00L) >> 8);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void writeUint64(long n) {
        this.check(8);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00000000000000L) >> 56);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF000000000000L) >> 48);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF0000000000L) >> 40);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00000000L) >> 32);
        this.buffer[this.write_pos++] = (byte)((n & 0xFFFFFFFFFF000000L) >> 24);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF0000L) >> 16);
        this.buffer[this.write_pos++] = (byte)((n & 0xFF00L) >> 8);
        this.buffer[this.write_pos++] = (byte)(n & 0xFFL);
    }

    public void write(byte[] vector) {
        this.check(vector.length);
        System.arraycopy(vector, 0, this.buffer, this.write_pos, vector.length);
        this.write_pos += vector.length;
    }

    public boolean hasData() {
        return this.write_pos > this.write_pos_beg;
    }

    public byte[] getData(int length) {
        byte[] res;
        if (this.write_pos - this.write_pos_beg < length) {
            res = new byte[this.write_pos - this.write_pos_beg];
            System.arraycopy(this.buffer, this.write_pos_beg, res, 0, this.write_pos - this.write_pos_beg);
            this.write_pos_beg = this.write_pos;
        } else {
            res = new byte[length];
            System.arraycopy(this.buffer, this.write_pos_beg, res, 0, length);
            this.write_pos_beg += length;
        }
        return res;
    }

    public void printContent(PrintStream outstream) {
        int perLine = 20;
        String prefix = " ";
        String delimiter = "";
        for (int i = this.write_pos_beg; i < this.write_pos; ++i) {
            String tail = Integer.toHexString(0xFF & this.buffer[i]).toUpperCase();
            if (tail.length() == 1) {
                tail = "0" + tail;
            }
            outstream.print(prefix + tail + delimiter);
            if ((i - this.write_pos_beg + 1) % 10 == 0) {
                outstream.print(" ");
            }
            if ((i - this.write_pos_beg + 1) % perLine != 0) continue;
            outstream.println();
        }
        outstream.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDigestMD5() {
        MessageDigest messageDigest = md5;
        synchronized (messageDigest) {
            int len = this.read_pos_end > this.write_pos ? this.read_pos_end : this.write_pos;
            md5.update(this.buffer, 0, len);
            return md5.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDigestSHA() {
        MessageDigest messageDigest = sha;
        synchronized (messageDigest) {
            int len = this.read_pos_end > this.write_pos ? this.read_pos_end : this.write_pos;
            sha.update(this.buffer, 0, len);
            return sha.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDigestMD5withoutLast() {
        MessageDigest messageDigest = md5;
        synchronized (messageDigest) {
            md5.update(this.buffer, 0, this.marked_pos);
            return md5.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDigestSHAwithoutLast() {
        MessageDigest messageDigest = sha;
        synchronized (messageDigest) {
            sha.update(this.buffer, 0, this.marked_pos);
            return sha.digest();
        }
    }

    public byte[] getMessages() {
        int len = this.read_pos_end > this.write_pos ? this.read_pos_end : this.write_pos;
        byte[] res = new byte[len];
        System.arraycopy(this.buffer, 0, res, 0, len);
        return res;
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not initialize the Digest Algorithms.");
        }
    }
}

