/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>

#include <pfs.h>

static ACL	aclflist = NULL;
int		acl_count = 0;
int		acl_max = 0;

/*
 * acalloc - allocate and initialize access control list structure
 *
 *    ACALLOC returns a pointer to an initialized structure of type
 *    ACL.  If it is unable to allocate such a structure, it
 *    returns NULL.
 */
ACL
acalloc()
    {
	ACL	acl_ent;
	if(aclflist) {
	    acl_ent = aclflist;
	    aclflist = aclflist->next;
	}
	else {
	    acl_ent = (ACL) malloc(sizeof(ACL_ST));
	    if (!acl_ent) return(NULL);
	    acl_max++;
	}

	acl_count++;

	/* Initialize and fill in default values */
	acl_ent->acetype = 0;
	acl_ent->atype = NULL;
        acl_ent->rights = NULL;
        acl_ent->principals = NULL;
        acl_ent->restrictions = NULL;
        acl_ent->previous = NULL;
        acl_ent->next = NULL;
	return(acl_ent);
    }

/*
 * acfree - free an ACL structure
 *
 *    ACFREE takes a pointer to an ACL structure and adds it to
 *    the free list for later reuse.
 */
acfree(acl_ent)
    ACL		acl_ent;
    {
	acl_ent->acetype = 0;
	if(acl_ent->atype) stfree(acl_ent->atype);
	if(acl_ent->rights) stfree(acl_ent->rights);
        if(acl_ent->principals) stfree(acl_ent->principals);
	/* If acl_ent->restrict, error since not yet implemented */

	acl_ent->next = aclflist;
	if(aclflist) aclflist->previous = acl_ent;
	acl_ent->previous = NULL;
	aclflist = acl_ent;
	acl_count--;
	return(PSUCCESS);
    }

/*
 * aclfree - free an ACL structure
 *
 *    ACLFREE takes a pointer to an ACL structure frees it and any linked
 *    ACL structures.  It is used to free an entrie list of ACL
 *    structures.
 */
aclfree(acl_ent)
    ACL		acl_ent;
    {
	ACL	nxt;

	while(acl_ent != NULL) {
	    nxt = acl_ent->next;
	    acfree(acl_ent);
	    acl_ent = nxt;
	}
	return(PSUCCESS);
    }

