/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <pcompat.h>

#include <sys/param.h>
#include <netdb.h>

static char	myhname[100];
static long	myhaddr;

char 		*myhostname();

long myaddress()
    {
	static  long	myaddr = 0;

	/* First time called, make sure myhostname has been run */
	if(!myaddr) myhostname();
	return(myhaddr);
    }

char *myhostname()
    {
	static int	initialized = 0;

	/* First time called, find out hostname and remember it */
	if(!initialized++) {
	    struct hostent	*current_host;

	    gethostname(myhname,sizeof(myhname));
	    /* gethostbyname reads files, so we must disable pfs */
	    DISABLE_PFS(current_host = gethostbyname(myhname));
	    strcpy(myhname,current_host->h_name);
	    ucase(myhname);

	    /* Save the address too */
	    bcopy(current_host->h_addr,&myhaddr,4);
	}
	return(myhname);
    }
