/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>

extern int	pfs_debug;

/*
 */
update_link(dirname,components)
    char	*dirname;	/* Directory name           */
    char	*components;	/* Components to be updated */
    {

	char		*dirhst;	   /* Host of current directory    */
	char		*remdir;	   /* Dir on remote host	   */
	
        PTEXT		request;	/* Text of request to dir server   */
	PTEXT		resp;	    	/* Response from dir server	   */

	char		fwdhst[MAX_DIR_LINESIZE];
	char		fwdfnm[MAX_DIR_LINESIZE];

	VDIR_ST		dir_st;
	VDIR		dir = &dir_st;

	PAUTH		authinfo;

	int		tmp;

	vdir_init(dir);

        /* We must first find the directory containing the */
	/* links to be updated                             */

	tmp = rd_vdir(dirname,0,dir,RVD_DFILE_ONLY);
	if (tmp || (dir->links == NULL)) return(DIRSRV_NOT_DIRECTORY);
	dirhst = dir->links->host;
	remdir = dir->links->filename;

    startover:

	request = ptalloc();
	
	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

	sprintf(request->start,
          "VERSION %d %s\nAUTHENTICATOR %s %s\nDIRECTORY ASCII %s\nUPDATE COMPONENTS %s\n",
		VFPROT_VNO, PFS_SW_ID, authinfo->auth_type, 
		authinfo->authenticator, remdir, components);
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	resp = dirsend(request,dirhst,0);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	if(resp == NULL) return(perrno);

	/* Here we parse the response.  Right now we just check the */
	/* first packet.  For this request, it should not take      */
	/* any more than one. If UPDATED, then we were successful   */
	/* if FAILURE, or anything else, we failed, and should      */
        /* return an appropriate error                              */

	if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	if(*(resp->start) != 'U') {

	    if(strncmp(resp->start,"NOT-A-DIRECTORY",15) == 0) {
		ptlfree(resp);
		return(DIRSRV_NOT_DIRECTORY);
	    }

	    /* FORWARDED */
	    if(strncmp(resp->start,"FORWARDED",9) == 0) {
		/* parse and start over */

		tmp = sscanf(resp->start,"FORWARDED %*s %s %*s %s %*d %*d", 
			     fwdhst,fwdfnm);

		dirhst = stcopy(fwdhst);
		remdir = stcopy(fwdfnm);

		ptlfree(resp);

		if(tmp < 2) return(DIRSRV_BAD_FORMAT);
		else goto startover;
	    }

	    /* We should return specific error codes.  Maybe have  */
            /* a routine which will parse the response and turn    */
            /* it into an error code                               */
	    if(pfs_debug)
		fprintf(stderr,"UPDATE: %s\n",resp->start);
	    
	    ptlfree(resp);
	    return(PFAILURE);
	}
	    
	ptlfree(resp);
	return(PSUCCESS);
    }

