#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>

#ifdef MMAP
#include <sys/mman.h>
#endif

/* Archie definitions */
#include <ndbm.h>
#include <defines.h>
#include <archie_defs.h>
#include <structs.h>
#include <database.h>
#include <error.h>

#include "prarch.h"

#include <pfs.h>
#include <perrno.h>

VLINK	atoplink();

char *re_comp();
char *make_lcase();
int get_match_list();

extern char *strings_begin;
extern long strings_table_size;
extern DBM *fast_strings;


/*
 * prarch_host - Search host for contents of directory 
 *
 *  ARGS: site_name - name of host for which search is to be made
 *          dirname - name of directory to return
 *               vd - pointer to directory to be filled in
 *        archiedir - flag - directory links should be to archie 
 */
int prarch_host(site_name,dirname,vd,archiedir)
    char	*site_name; 	/* Name of host to be searched            */
    char	*dirname;	/* Name of directory to be listed         */
    VDIR	vd;		/* Directory to be filled in              */
    int		archiedir;	/* Flag: directory links s/b to archie    */
    {
	extern char *get_host_file_name();
	FILE *site_fp;
	site_out	so;
	char *host_name;
	int rval;
	char result[MAX_STRING_LEN];
	char host_str[MAX_HOST_LEN];
	char date_str[SMALL_STR_LEN];
	char hostip_str[SMALL_STR_LEN];
	site_rec curr_site_rec;
	int recno;
	int last_parent = -1;  
	site_rec *site_ptr;
	int errno;
	VLINK cur_link;
	int	correct_dir = 0; /* Scanning the requested directory */
	int	loopcount = 0;

#ifdef MMAP

	caddr_t site_begin;
	site_rec *site_end;
	struct stat statbuf;
	
#endif

	bzero(&so,sizeof(so));

	if(( host_name = get_host_file_name( site_name )) == (char *)NULL )
	    return(PRARCH_DONT_HAVE_SITE);

	if((site_fp = fopen(host_name, "r")) == NULL) 
	    return(PRARCH_CANT_OPEN_FILE);

#ifndef MMAP

	if(fseek(site_fp,(long) sizeof(site_rec),0) != 0) {
	    fclose(site_fp);
	    return(PRARCH_DB_ERROR);
	}

	if(print_sinfo(site_fp,so.site_name,hostip_str,date_str) != 0) {
	    fclose(site_fp);
	    return(PRARCH_DB_ERROR);
	}

	for( recno = 1; fread((char *)&curr_site_rec, 
			      sizeof(site_rec), 1, site_fp) != 0 ; recno++){
	
	    if((loopcount++ & 0x3ff) == 0) check_for_messages();

	    if(last_parent != curr_site_rec.parent_ind){
		if(find_ancestors(site_fp, recno, result) != 0) {
		    fclose(site_fp);
		    return(PRARCH_DB_ERROR) ;
		}

		if(fseek(site_fp, (long)sizeof(site_rec), 1) == -1) {
		    fclose(site_fp);
		    return(PRARCH_DB_ERROR);
		}

		last_parent = curr_site_rec.parent_ind ;

		/* Don't want to check the leading / */
		if(strcmp(dirname,result+1) == 0)  {
		    correct_dir++;
		    strcpy(so.site_path,result);
		}
		else if(correct_dir) break;
	    }
	    /* Here we want to make it into a link */
	    if(correct_dir) {
		if((loopcount & 0x7f) == 0) check_for_messages();
		cur_link = atoplink(&so,archiedir);
		if(cur_link) vl_insert(cur_link,vd,VLI_NOSORT);
	    }
	}
#else /* MMAP defined */

	if(fstat(fileno(site_fp),&statbuf) == -1) {
	    fclose(site_fp);
	    return(PRARCH_CANT_OPEN_FILE);
	}

	site_begin = mmap(0,statbuf.st_size,PROT_READ,MAP_SHARED,
			  fileno(site_fp),0);   

	if((site_begin == (caddr_t) -1) || (site_begin == (caddr_t) NULL))  {
	    fclose(site_fp);
	    return(PRARCH_CANT_OPEN_FILE);
	}

	if(print_sinfo(site_begin,so.site_name,hostip_str,date_str) != 0) {
	    munmap(site_begin,statbuf.st_size);
	    fclose(site_fp);
	    return(PRARCH_DB_ERROR);
	}

	site_end = (site_rec *)site_begin + statbuf.st_size / sizeof(site_rec);

	for(recno = 1;(site_ptr = (site_rec *)site_begin + recno) < site_end; 
	    recno++){

	    if((loopcount++ & 0x3ff) == 0) check_for_messages();

	    curr_site_rec = *site_ptr;

	    if(last_parent != curr_site_rec.parent_ind){

		if(find_ancestors(site_begin, recno, result) != 0) {
		    munmap(site_begin,statbuf.st_size);
		    fclose(site_fp);
		    return(PRARCH_DB_ERROR);
		}

		last_parent = curr_site_rec.parent_ind;

		/* Don't want to check the leading / */
		if(strcmp(dirname,result+1) == 0)  {
		    correct_dir++;
		    strcpy(so.site_path,result);
		}
		else if(correct_dir) break;
	    }
	    bcopy(&curr_site_rec,&(so.site_ent),sizeof(curr_site_rec));
	    if(correct_dir) {
		if((loopcount & 0x7f) == 0) check_for_messages();
		cur_link = atoplink(&so,archiedir);
		if(cur_link) vl_insert(cur_link,vd,VLI_NOSORT);
	    }
	}

	munmap(site_begin,statbuf.st_size);
#endif
	fclose(site_fp);
	return(PRARCH_SUCCESS);
}


