/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>

#include <pfs.h>
#include <perrno.h>

prioritize_request(r1,r2)
    PREQ r1,r2;
    {
	if(!r1->pf_priority)
	    r1->pf_priority = assign_priority(r1);
	if(!r2->pf_priority)
	    r2->pf_priority = assign_priority(r2);

	if(r1->pf_priority == r2->pf_priority) return(0);
	else if (r1->pf_priority < r2->pf_priority) return(-1);
	else return(1);
    }


static assign_priority(r1)
    PREQ r1;
    {
	char	*arg_ptr;
	int	maxhit;
	int	offset;
	char	stype;
	int	tmp;
	int	retval;

	/* Result is probably cached, use it or lose it */
	if(r1->rcvd_thru > 0) return(2);

	arg_ptr = sindex(r1->recv->start,"ARCHIE");
	if(!arg_ptr) return(1);

	arg_ptr = sindex(arg_ptr,"MATCH");
	if(!arg_ptr) return(3);

	tmp = sscanf(arg_ptr,"MATCH(%d,%d,%c",&maxhit,&offset,&stype);

	if(tmp != 3) return(4);

	if(stype == '=') retval = 0;
	else retval = 100;

	tmp = maxhit;
	if(offset > 0) tmp += offset;

	if(tmp > 10000) retval += 10000;
	else if (tmp > 100) retval+= tmp;
	else retval+= 100;

	if(sindex(arg_ptr,"gif") || sindex(arg_ptr,"GIF")) retval += 20000;

	return(retval);
    }
