/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <sys/param.h>
#include <netdb.h>
#include <strings.h>

#include <pfs.h>
#include <pmachine.h>

/*
 * check_nfs - Check whether file is available by NFS
 *
 * 	  CHECK_NFS takes the name of a file and a network address.
 *        It returns the name of the filesystem (prefix of the file)
 *        which may be exported by NFS to the client.  The prefix is
 *        followed by a space and the suffix.  This is the form of the 
 *        paramters to be returned for access by NFS.
 *
 *    ARGS: path    - Name of file to be retrieved
 *          client  - IP address of the client
 *
 * RETURNS: Pointer to a string containing the name of the file system or
 *          NULL if the file is not available by NFS
 *
 *   NOTES: The returned string is static.  It must be copied if it
 *          is needed beyond the next call to check_nfs.
 *
 *    BUGS: The procedure should check the exports file.  Right now
 *          It only guesses at the prefix and check to make sure the
 *          request is from the local subnet. 
 */
char *
check_nfs(path,client)
    char 	*path;
    long	client;
    {
	static	char	args[MAXPATHLEN];
	static long	myaddr = 0;
	char		prefix[MAXPATHLEN];
	char		*suffix;
	char		*slash;

	/* First time called, find out hostname and remember it */
	if(!myaddr) myaddr = myaddress();

	/* XXX pit-manager specific */
	if (0 == strncmp("/site/mit/ftp/", path, 14)) {
	     strcpy(prefix, "/ua/ftp/");
	     strcat(prefix, path + 14);
	}
	else {
	     strcpy(prefix,path);
	}
	if (0 == strncmp("/afs/", prefix, 5)) {
	     return(NULL);
	}

	slash = index(prefix+1,'/');
	if(slash) {*slash = '\0'; suffix = slash + 1;}
	else return(NULL);

	sprintf(args,"%s %s",prefix,suffix);
	return(args);
    }


