module Paths_haddock_library (
    version,
    getBinDir, getLibDir, getDataDir, getLibexecDir,
    getDataFileName, getSysconfDir
  ) where

import qualified Control.Exception as Exception
import Data.Version (Version(..))
import System.Environment (getEnv)
import Prelude

catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
catchIO = Exception.catch

version :: Version
version = Version [1,2,0] []
bindir, libdir, datadir, libexecdir, sysconfdir :: FilePath

bindir     = "/home/ben/.cabal/bin"
libdir     = "/home/ben/.cabal/lib/x86_64-linux-ghc-7.10.0.20150119/haddo_8vYeokI9LaO875Eqzwa0tj"
datadir    = "/home/ben/.cabal/share/x86_64-linux-ghc-7.10.0.20150119/haddock-library-1.2.0"
libexecdir = "/home/ben/.cabal/libexec"
sysconfdir = "/home/ben/.cabal/etc"

getBinDir, getLibDir, getDataDir, getLibexecDir, getSysconfDir :: IO FilePath
getBinDir = catchIO (getEnv "haddock_library_bindir") (\_ -> return bindir)
getLibDir = catchIO (getEnv "haddock_library_libdir") (\_ -> return libdir)
getDataDir = catchIO (getEnv "haddock_library_datadir") (\_ -> return datadir)
getLibexecDir = catchIO (getEnv "haddock_library_libexecdir") (\_ -> return libexecdir)
getSysconfDir = catchIO (getEnv "haddock_library_sysconfdir") (\_ -> return sysconfdir)

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = do
  dir <- getDataDir
  return (dir ++ "/" ++ name)
