#! /bin/sh
ATHSAVE=.athsave

prepare-to-patch () { # file-to-patch patch-file
    [ -f $1 -a -f $2 ] || return 1
    if [ -f $1$ATHSAVE ]; then
	cp $1$ATHSAVE $1
    else
	cp $1 $1$ATHSAVE
    fi
}

# Red Hat classifies most of these (but oddly not /etc/inetd.conf) as
# config files, but we want to handle upgrades to both Red Hat's and
# our packages as smoothly as possible.

for x in /sbin/ifup /sbin/ifdown /etc/rc.d/init.d/sendmail \
  /etc/sysconfig/network-scripts/ifdhcpc-done; do
    diff=/etc/athena/`basename $x`.diff
    prepare-to-patch $x $diff && patch -f $x $diff
done

for x in /etc/inetd.conf /etc/inittab /etc/services; do
    script=/etc/athena/`basename $x`.sed
    prepare-to-patch $x $script && sed -f $script $x$ATHSAVE > $x
done
