"""Final tweaks that turn the box into an athena machine."""

from latest_version import latest_version_string
import string, shutil, time, re

def inittab():

    """Modifications to inittab"""
    
    shutil.copyfile('/etc/inittab', '/var/athena/inittab.bak')
    inittab = open('/etc/inittab').read()

    # Change default run level to 5
    new_inittab = string.replace(inittab, 'id:3', 'id:5')
    open('/var/tmp/inittab', 'w').write(new_inittab)
    shutil.copyfile('/var/tmp/inittab', '/etc/inittab')

def version():
    
    """Record of installation"""

    current_time = time.ctime(time.time())
    open('/etc/athena/version', 'a').write("""
Kludged install by SIPB on %s
Athena Workstation (linux) Version %s %s
""" % (current_time, latest_version_string, current_time))

def main(): inittab(); version()
    
if __name__ == '__main__': main()
