;/* Copyright (C) 1998  Transarc Corporation.  All rights reserved.
; *
; * event.mc --(mc)--> event.[h|rc] --(logevent.h + event.h)--> afsevent.h
; */
;
;#ifndef TRANSARC_AFSEVENT_H
;#define TRANSARC_AFSEVENT_H
;
;
;/* AFS event.mc format.
; *
; * AFS event messages are grouped by category.  The MessageId of the
; * first message in a given category specifies the starting identifier
; * range for that category; the second and later messages in a category
; * do NOT specify a MessageId value and thus receive the value of the
; * previous message plus one.
; *
; * To add a new message to an existing category, append it to the end of
; * that category.  To create a new category, provide an appropriate
; * comment line and specify a non-conflicting MessageId for the first
; * message in the new category.
; */
;


MessageIdTypedef=unsigned
LanguageNames=(German=1:MSG000001)
;
;/* Test message text */
;

MessageId=0x0001
Severity=Informational
SymbolicName=AFSEVT_SVR_TEST_MSG_NOARGS
Language=German
Testnachricht fr das AFS-Server-Ereignisprotokoll.
.

MessageId=
Severity=Warning
SymbolicName=AFSEVT_SVR_TEST_MSG_TWOARGS
Language=German
Testnachricht fr das AFS-Server-Ereignisprotokoll (Zeichenfolge1: %1, Zeichenfolge2: %2).
.



;
;/* General messages for all AFS server processes */
;

MessageId=0x0101
Severity=Error
SymbolicName=AFSEVT_SVR_FAILED_ASSERT
Language=German
Ein AFS-Server-Proze konnte kein Assert durchfhren: Zeile %1 in Datei %2.
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_NO_INSTALL_DIR
Language=German
%1 konnte das Installationsverzeichnis der AFS-Software nicht finden.
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_WINSOCK_INIT_FAILED
Language=German
%1 konnte die Windows Sockets-Bibliothek nicht initialisieren.
.



;
;/* AFS BOS control (startup/shutdown) service messages */
;

MessageId=0x0201
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_STARTED
Language=German
Der AFS BOS-Steuerungsservice wurde gestartet.
.

MessageId=
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_STOPPED
Language=German
Der AFS BOS-Steuerungsservice wurde beendet.
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_SCM_COMM_FAILED
Language=German
Der AFS BOS-Steuerungsservice kann keine Daten zum System-SCM bertragen.
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_HANDLER_REG_FAILED
Language=German
Der AFS BOS-Steuerungsservice kann keine Ereignissteuerroutine registrieren.  Die AFS-Server-Software ist mglicherweise nicht einwandfrei konfiguriert.
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_INSUFFICIENT_RESOURCES
Language=German
Der AFS BOS-Steuerungsservice kann die erforderlichen Systemressourcen nicht erhalten.
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_INTERNAL_ERROR
Language=German
Im AFS BOS-Steuerungsservice ist ein interner Fehler aufgetreten.
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_NO_INSTALL_DIR
Language=German
Der AFS BOS-Steuerungsservice konnte das Installationsverzeichnis der AFS-Software nicht finden. Die AFS-Server-Software ist mglicherweise nicht einwandfrei konfiguriert.
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_START_FAILED
Language=German
Der AFS BOS-Steuerungsservice konnte den AFS BOS-Server nicht oder nicht erneut starten.
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_STOP_FAILED
Language=German
Der AFS BOS-Steuerungsservice konnte den AFS BOS-Server nicht beenden. Alle AFS-Server-Prozesse mssen manuell beendet werden (versuchen Sie, ber den Befehl afskill dem AFS BOS-Server ein SIGQUIT-Signal zu senden).
.

MessageId=
Severity=Warning
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_STOP_TIMEOUT
Language=German
Der AFS BOS-Steuerungsservice wartet nicht mehr lnger auf das Beenden des AFS BOS-Servers. berprfen Sie vor dem Neustart des Service, ob alle AFS-Server-Prozesse beendet wurden.
.

MessageId=
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_RESTART
Language=German
Der AFS BOS-Steuerungsservice startet den AFS BOS-Server neu.
.

MessageId=
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_EXIT
Language=German
Der AFS BOS-Steuerungsservice hat festgestellt, da der AFS BOS-Server ohne Anforderung eines Neustarts beendet wurde.
.



;
;#endif /* TRANSARC_AFSEVENT_H */
