/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

class OracleConnectionCacheEventListener
implements ConnectionEventListener,
Serializable {
    static final int CONNECTION_CLOSED_EVENT = 101;
    static final int CONNECTION_ERROROCCURED_EVENT = 102;
    protected OracleImplicitConnectionCache implicitCache = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Aug_23_13:32:03_PDT_2011";
    public static final boolean TRACE = false;

    public OracleConnectionCacheEventListener() {
        this(null);
    }

    public OracleConnectionCacheEventListener(OracleImplicitConnectionCache oracleImplicitConnectionCache) {
        this.implicitCache = oracleImplicitConnectionCache;
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            if (this.implicitCache != null) {
                this.implicitCache.reusePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            if (this.implicitCache != null) {
                this.implicitCache.closePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

