/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.DataDescriptorPacket;
import oracle.net.ns.DataPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class NetInputStream
extends InputStream
implements SQLnetDef {
    protected DataPacket daPkt;
    protected DataDescriptorPacket ddPkt;
    protected MarkerPacket mkPkt;
    protected SessionAtts sAtts;
    private byte[] tmpBuf = new byte[1];

    public NetInputStream() {
    }

    public NetInputStream(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
        this.daPkt = new DataPacket(sessionAtts);
        this.ddPkt = new DataDescriptorPacket(this.daPkt, sessionAtts);
    }

    public int read() throws IOException, NetException, BreakNetException {
        if (this.sAtts.enableJavaNetFastPath && !this.sAtts.anoActive) {
            if (this.daPkt == null || this.daPkt.availableBytesToRead <= 0 || this.daPkt.type == 7) {
                this.getNextPacket();
            }
            return this.daPkt.get1ByteDataFromBuffer() & 0xFF;
        }
        return this.read(this.tmpBuf) < 0 ? -1 : this.tmpBuf[0] & 0xFF;
    }

    public int readB1() throws IOException, NetException, BreakNetException {
        return this.read();
    }

    public long readLongLSB(int n2) throws BreakNetException, NetException, IOException {
        long l2 = 0L;
        boolean bl = false;
        if ((n2 & 0x80) > 0) {
            n2 &= 0x7F;
            bl = true;
        }
        if (this.sAtts.anoActive || this.daPkt.availableBytesToRead < n2) {
            int n3 = n2;
            int n4 = 0;
            while (n3 > 0) {
                l2 |= ((long)this.read() & 0xFFL) << 8 * n4;
                --n3;
                ++n4;
            }
        } else {
            l2 = this.daPkt.readLongLSB(n2);
        }
        return (long)(bl ? -1 : 1) * l2;
    }

    public long readLongMSB(int n2) throws BreakNetException, NetException, IOException {
        long l2 = 0L;
        boolean bl = false;
        if ((n2 & 0x80) > 0) {
            n2 &= 0x7F;
            bl = true;
        }
        if (this.sAtts.anoActive || this.daPkt.availableBytesToRead < n2) {
            for (int i2 = n2; i2 > 0; --i2) {
                l2 |= ((long)this.read() & 0xFFL) << 8 * (i2 - 1);
            }
        } else {
            l2 = this.daPkt.readLongMSB(n2);
        }
        return (long)(bl ? -1 : 1) * l2;
    }

    public int read(byte[] byArray) throws IOException, NetException, BreakNetException {
        return this.read(byArray, 0, byArray.length);
    }

    public boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException, NetException, BreakNetException {
        boolean bl = false;
        if (this.sAtts.nsOutputStream.available() > 0) {
            this.sAtts.nsOutputStream.flush();
        }
        this.ddPkt.receive();
        int n3 = this.ddPkt.totalDataLength;
        if ((this.ddPkt.descriptorFLaG & 1) != 0) {
            bl = true;
        }
        if (byArray.length < n2 + n3) {
            throw new IOException("Assertion Failed");
        }
        int n4 = this.ddPkt.packet.readLocal(byArray, n2, n3);
        while (n4 < n3) {
            try {
                if ((n4 += this.sAtts.ntInputStream.read(byArray, n4 + n2, n3 - n4)) > 0) continue;
                throw new NetException(0);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new NetException(504);
            }
        }
        nArray[0] = n4;
        return bl;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException, NetException, BreakNetException {
        int n4 = 0;
        try {
            do {
                if (this.daPkt != null && this.daPkt.availableBytesToRead > 0 && this.daPkt.type != 7) continue;
                this.getNextPacket();
            } while ((n4 += this.daPkt.getDataFromBuffer(byArray, n2 + n4, n3 - n4)) < n3);
        }
        catch (NetException netException) {
            if (netException.getErrorNumber() == 0) {
                return -1;
            }
            throw netException;
        }
        return n4;
    }

    public int available() throws IOException {
        return this.daPkt.availableBytesToRead;
    }

    protected void getNextPacket() throws IOException, NetException, BreakNetException {
        if (this.sAtts.dataEOF) {
            throw new NetException(202);
        }
        if (this.sAtts.nsOutputStream.available() > 0) {
            this.sAtts.nsOutputStream.flush();
        }
        this.daPkt.receive();
        switch (this.daPkt.type) {
            case 6: {
                this.daPkt.availableBytesToRead = this.daPkt.dataLen;
                break;
            }
            case 12: {
                this.mkPkt = new MarkerPacket(this.daPkt);
                this.daPkt.availableBytesToRead = 0;
                this.sAtts.onBreakReset = this.mkPkt.isBreakPkt();
                this.processMarker();
                throw new BreakNetException(500);
            }
            case 7: {
                this.daPkt.availableBytesToRead = this.daPkt.dataLen;
                break;
            }
            default: {
                throw new NetException(205);
            }
        }
    }

    protected void processMarker() throws IOException, NetException, BreakNetException {
    }

    void poolEnabled(boolean bl) throws IOException, NetException, BreakNetException {
        if (bl) {
            this.daPkt.setFlags(1);
        }
    }

    void reinitialize(SessionAtts sessionAtts) throws NetException {
        this.sAtts = sessionAtts;
    }

    Packet getCurrentPacket() throws IOException, NetException {
        return this.daPkt;
    }
}

