/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.config.AddressConfig;
import oracle.net.config.AddressListConfig;
import oracle.net.config.Config;
import oracle.net.config.ConfigException;
import oracle.net.config.DescriptionConfig;
import oracle.net.config.DescriptionListConfig;
import oracle.net.config.Listener;
import oracle.net.config.ListenerException;
import oracle.net.config.Profile;
import oracle.net.config.ProfileException;
import oracle.net.config.SchemaObjectConfig;
import oracle.net.config.SchemaObjectConfigFactory;
import oracle.net.config.ServiceAlias;
import oracle.net.config.ServiceAliasException;
import oracle.net.nl.NLException;

public class NetConfig {
    String[] listenerNames;
    Vector listenerAddresses;
    String[] passwords;
    AddressConfig addressToSet;
    Config netConfig;
    public static String SID_NAME = "SID_NAME";
    public static String GLOBAL_DBNAME = "GLOBAL_DBNAME";
    public static String ORACLE_HOME = "ORACLE_HOME";

    public NetConfig(String string) {
        try {
            this.netConfig = new Config(string, 0, null);
            this.listenerAddresses = new Vector();
            return;
        }
        catch (ConfigException configException) {
            System.out.println("ConfigException:  " + (Object)((Object)configException));
            return;
        }
    }

    public boolean enumerateListenerAddresses(String string) {
        try {
            Listener listener = new Listener(this.netConfig, string);
            if (listener.numOfEndpoints() == 1) {
                Enumeration enumeration = listener.enumEndpoints();
                SchemaObjectConfig schemaObjectConfig = (SchemaObjectConfig)enumeration.nextElement();
                this.enumerateAddresses(schemaObjectConfig, this.listenerAddresses);
            }
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException:  " + (Object)((Object)listenerException));
            return false;
        }
        return true;
    }

    private void enumerateAddresses(SchemaObjectConfig schemaObjectConfig, Vector vector) {
        DescriptionListConfig descriptionListConfig;
        if (schemaObjectConfig.isA() == 0) {
            vector.addElement(schemaObjectConfig);
            return;
        }
        Vector vector2 = new Vector();
        if (schemaObjectConfig.isA() == 3) {
            descriptionListConfig = (DescriptionListConfig)schemaObjectConfig;
            vector2 = descriptionListConfig.children;
        } else if (schemaObjectConfig.isA() == 2) {
            descriptionListConfig = (DescriptionConfig)schemaObjectConfig;
            if (descriptionListConfig.protocolStacks.size() == 0) {
                vector2 = descriptionListConfig.children;
            }
        } else if (schemaObjectConfig.isA() == 1) {
            descriptionListConfig = (AddressListConfig)schemaObjectConfig;
            vector2 = descriptionListConfig.children;
        }
        int n = 0;
        while (n < vector2.size()) {
            SchemaObjectConfig schemaObjectConfig2 = (SchemaObjectConfig)vector2.elementAt(n);
            this.enumerateAddresses(schemaObjectConfig2, vector);
            ++n;
        }
    }

    public boolean addBequeathServiceAlias(String string, String string2) {
        String[] stringArray = new String[]{"(ADDRESS=(COMMUNITY=beq.world)(PROTOCOL=BEQ)(PROGRAM=" + string + ")(ARGV0=" + string + string2 + ")(ARGS='(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=beq)))'))"};
        boolean bl = this.netConfig.netConfigUsesLDAP();
        this.netConfig.netConfigUsesLDAP(false);
        try {
            ServiceAlias.createSimpleAlias((Config)this.netConfig, (boolean)true, (String)"beq.world", (String[])stringArray, null, null, (String)string2);
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println("ServiceAliasException in addBequeathServiceAlias:  " + (Object)((Object)serviceAliasException));
            return false;
        }
        this.netConfig.netConfigUsesLDAP(bl);
        return true;
    }

    public String[] enumerateListeners() {
        this.listenerNames = Listener.enumListeners((Config)this.netConfig);
        return this.listenerNames;
    }

    public boolean addAddressToListener(String string, String string2, boolean bl) {
        Listener listener;
        try {
            listener = new Listener(this.netConfig, string);
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException:  " + (Object)((Object)listenerException));
            return false;
        }
        String string3 = "(ADDRESS=" + string2 + ")";
        SchemaObjectConfigFactory schemaObjectConfigFactory = new SchemaObjectConfigFactory();
        AddressConfig addressConfig = (AddressConfig)schemaObjectConfigFactory.create(0);
        AddressListConfig addressListConfig = (AddressListConfig)schemaObjectConfigFactory.create(1);
        try {
            addressConfig.initFromString(string3);
        }
        catch (NLException nLException) {
            System.out.println("NLException in addListenerToAddress:  " + (Object)((Object)nLException));
            return false;
        }
        catch (SOException sOException) {
            System.out.println("SOException in addListenerToAddress:  " + (Object)((Object)sOException));
            return false;
        }
        try {
            addressListConfig.addChild((SchemaObjectConfig)addressConfig);
            Vector<AddressListConfig> vector = new Vector<AddressListConfig>();
            vector.addElement(addressListConfig);
            listener.setEndpoints(vector);
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException in addAddressToListener:  " + (Object)((Object)listenerException));
            return false;
        }
        try {
            listener.save(this.netConfig, true);
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException in addAddressToListener:  " + (Object)((Object)listenerException));
            return false;
        }
        return true;
    }

    public boolean addSidToListener(String string, String string2, boolean bl) {
        return this.addItemToSIDList(string, "(SID_DESC=(SID_NAME=" + string2 + "))", bl);
    }

    public boolean addSidToListener(String string, String string2, String string3, String string4, boolean bl) {
        return this.addItemToSIDList(string, "(SID_DESC=(GLOBAL_DBNAME=" + string2 + ")(ORACLE_HOME=" + string3 + ")(SID_NAME=" + string4 + "))", bl);
    }

    public String getSID_DESC(String string, String string2) {
        Listener listener;
        try {
            listener = new Listener(this.netConfig, string);
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException:  " + (Object)((Object)listenerException));
            return null;
        }
        String[] stringArray = listener.enumSID_DESCs();
        int n = 0;
        while (n < stringArray.length) {
            String string3 = NetConfig.getValueFromSID_DESC(stringArray[n], SID_NAME);
            if (string3 == null) {
                return null;
            }
            if (string3.equals(string2)) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    public static String getValueFromSID_DESC(String string, String string2) {
        String string3;
        String string4;
        int n;
        StringTokenizer stringTokenizer;
        if (string == null || string.length() == 0) {
            return null;
        }
        if ((string = string.trim()).charAt(0) == '(' && string.length() > 1) {
            string = string.substring(1, string.length());
        }
        if ((stringTokenizer = new StringTokenizer(string, "(")).hasMoreTokens() && (n = (string4 = stringTokenizer.nextToken()).indexOf("=")) != -1 && (string3 = string4.substring(0, n).trim()).equalsIgnoreCase("SID_DESC")) {
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                n = string4.indexOf("=");
                if (n == -1 || !(string3 = string4.substring(0, n).trim()).equalsIgnoreCase(string2)) continue;
                int n2 = string4.indexOf(")");
                if (n == -1) continue;
                return string4.substring(n + 1, n2).trim();
            }
        }
        return null;
    }

    public String[] getSID_DESCs(String string) {
        Listener listener;
        try {
            listener = new Listener(this.netConfig, string);
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException:  " + (Object)((Object)listenerException));
            return null;
        }
        return listener.enumSID_DESCs();
    }

    public void setFilename(int n, String string) {
        this.netConfig.setFilename(n, string);
    }

    public boolean deleteSidFromListener(String string, String string2) {
        Listener listener;
        try {
            listener = new Listener(this.netConfig, string);
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException:  " + (Object)((Object)listenerException));
            return false;
        }
        listener.delSidDesc(string2);
        try {
            listener.save(this.netConfig, true);
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException in addItemtoSIDList:  " + (Object)((Object)listenerException));
            return false;
        }
        return true;
    }

    public boolean addExtprocToListener(String string, boolean bl) {
        return this.addItemToSIDList(string, "(SID_DESC=(SID_NAME=EXTPROC)(PROGRAM=EXTPROC))", bl);
    }

    public boolean addItemToSIDList(String string, String string2, boolean bl) {
        Listener listener;
        try {
            listener = new Listener(this.netConfig, string);
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException:  " + (Object)((Object)listenerException));
            return false;
        }
        listener.addSidDesc(string2, bl);
        try {
            listener.save(this.netConfig, true);
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException in addItemtoSIDList:  " + (Object)((Object)listenerException));
            return false;
        }
        return true;
    }

    public String getLocalListenerEntry(String string) {
        if (!this.determineSimpleAlias(string)) {
            return null;
        }
        if (!this.addressToSet.prot.equalsIgnoreCase("TCP") || this.addressToSet.prot.equalsIgnoreCase("TCP") && !this.addressToSet.getProtocolParam("PORT").equalsIgnoreCase("1521")) {
            return this.addressToSet.addr;
        }
        return null;
    }

    public boolean determineSimpleAlias(String string) {
        String string2;
        if (!this.enumerateListenerAddresses(string)) {
            return false;
        }
        int n = 0;
        while (n < this.listenerAddresses.size()) {
            String string3 = ((AddressConfig)this.listenerAddresses.elementAt((int)n)).prot;
            if (string3.equalsIgnoreCase("TCP") && !(string2 = ((AddressConfig)this.listenerAddresses.elementAt(n)).getProtocolParam("HOST")).equalsIgnoreCase("127.0.0.1")) {
                String string4 = ((AddressConfig)this.listenerAddresses.elementAt(n)).getProtocolParam("PORT");
                if (string4.equalsIgnoreCase("1521")) {
                    this.addressToSet = (AddressConfig)this.listenerAddresses.elementAt(n);
                    break;
                }
                this.addressToSet = (AddressConfig)this.listenerAddresses.elementAt(n);
            }
            ++n;
        }
        if (this.addressToSet == null) {
            int n2 = 0;
            while (n2 < this.listenerAddresses.size()) {
                string2 = ((AddressConfig)this.listenerAddresses.elementAt((int)n2)).prot;
                if (!string2.equalsIgnoreCase("IPC")) {
                    this.addressToSet = (AddressConfig)this.listenerAddresses.elementAt(n2);
                }
                ++n2;
            }
        }
        return this.addressToSet != null;
    }

    public boolean addSimpleAlias(String string, String string2, String string3) {
        if (this.addressToSet == null && !this.determineSimpleAlias(string)) {
            return false;
        }
        String[] stringArray = new String[]{"(ADDRESS_LIST = " + this.addressToSet.addr + ")"};
        try {
            ServiceAlias.createSimpleAlias((Config)this.netConfig, (boolean)true, (String)string2, (String[])stringArray, null, null, (String)string3);
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println("ServiceAliasException in addAddress:  " + (Object)((Object)serviceAliasException));
            return false;
        }
        return true;
    }

    public boolean addSimpleAlias(String string, String string2) {
        String string3;
        if (this.addressToSet == null && !this.determineSimpleAlias(string)) {
            return false;
        }
        String[] stringArray = new String[]{"(ADDRESS_LIST = " + this.addressToSet.addr + ")"};
        Profile profile = null;
        try {
            profile = new Profile(this.netConfig, false, null);
        }
        catch (ProfileException profileException) {
            System.out.println("ProfileException in addSimpleAlias: " + (Object)((Object)profileException));
            return false;
        }
        String string4 = string2;
        int n = string2.indexOf(".");
        if (n > -1) {
            string4 = string2.substring(0, n);
        }
        if ((string3 = "." + profile.getParameter("NAMES.DEFAULT_DOMAIN")).equals(".") || string3.compareTo(".null") == 0) {
            string3 = "";
        }
        String string5 = String.valueOf(string4) + string3;
        try {
            ServiceAlias.createSimpleAlias((Config)this.netConfig, (boolean)true, (String)string5, (String[])stringArray, null, (String)string2, null);
        }
        catch (ServiceAliasException serviceAliasException) {
            System.out.println("ServiceAliasException in addAddress:  " + (Object)((Object)serviceAliasException));
            return false;
        }
        return true;
    }

    public boolean addMiscItemsToListener(String string, String string2) {
        this.addSidToListener(string, string2, true);
        this.addExtprocToListener(string, true);
        this.addAddressToListener(string, "(PROTOCOL=IPC)(KEY=" + string2 + ")", true);
        return true;
    }

    public String getPassword(String string) {
        try {
            Listener listener = new Listener(this.netConfig, string);
            String string2 = listener.getParameter("PASSWORDS");
            if (string2 == null) {
                return string2;
            }
            if (string2.startsWith("(") && string2.length() > 1) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith(")") && string2.length() > 1) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.length() == 0) {
                return null;
            }
            return string2;
        }
        catch (ListenerException listenerException) {
            System.out.println("ListenerException:  " + (Object)((Object)listenerException));
            return null;
        }
    }

    public String generateReloadScript(String[] stringArray) {
        String string = "";
        String string2 = "\r\nstart\r\nreload\r\n";
        this.passwords = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                Listener listener;
                try {
                    listener = new Listener(this.netConfig, stringArray[n]);
                }
                catch (ListenerException listenerException) {
                    System.out.println("ListenerException:  " + (Object)((Object)listenerException));
                    return null;
                }
                this.passwords[n] = listener.getParameter("PASSWORDS_" + stringArray[n]);
                if (this.passwords[n] != null) {
                    string = String.valueOf(string) + "set password " + this.passwords[n] + string2;
                }
            }
            ++n;
        }
        return string;
    }

    public String removeWhitespace(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            if (!Character.isWhitespace(string.charAt(n))) {
                string2 = String.valueOf(string2) + String.valueOf(string.charAt(n));
            }
            ++n;
        }
        return string2;
    }

    public String getSQLNetAuthenticationServices() {
        Profile profile;
        try {
            profile = new Profile(this.netConfig, true, "");
        }
        catch (ProfileException profileException) {
            System.out.println("ProfileException:  " + (Object)((Object)profileException));
            return "";
        }
        String string = profile.getParameter("sqlnet.authentication_services");
        return string;
    }
}

